/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.internal.core;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import tern.ITernProject;
import tern.eclipse.ide.core.ITernServerFactory;
import tern.eclipse.ide.server.nodejs.core.debugger.INodejsDebugger;
import tern.eclipse.ide.server.nodejs.core.debugger.NodejsDebuggersManager;
import tern.eclipse.ide.server.nodejs.internal.core.preferences.TernNodejsCorePreferencesSupport;
import tern.server.ITernServer;
import tern.server.nodejs.NodejsTernServer;

public class TernNodejsServerFactory
implements ITernServerFactory {
    public ITernServer create(ITernProject project) throws Exception {
        NodejsTernServer server;
        if (this.isRemoteAccess()) {
            server = new NodejsTernServer(project, this.getRemotePort());
        } else {
            INodejsDebugger debugger = NodejsDebuggersManager.getDebugger(this.getDebugger());
            File installPath = this.getInstallPath();
            IFile ternServerFile = this.getTernServerDebugFile();
            if (debugger != null && debugger.isInstalled() && ternServerFile != null && ternServerFile.exists() && !ternServerFile.getProject().equals(project.getAdapter(IProject.class))) {
                server = new NodejsTernServer(project, debugger.createProcess(project.getProjectDir(), installPath, ternServerFile));
            } else {
                File ternBaseDir = project.getRepository().getTernBaseDir();
                server = new NodejsTernServer(project, installPath, ternBaseDir);
            }
        }
        server.setTimeout(this.getTimeout());
        server.setTestNumber(this.getTestNumber());
        server.setPersistent(this.isPersistent());
        return server;
    }

    private boolean isRemoteAccess() {
        return TernNodejsCorePreferencesSupport.getInstance().isNodejsRemoteAccess();
    }

    private int getRemotePort() {
        return TernNodejsCorePreferencesSupport.getInstance().getNodejsRemotePort();
    }

    private File getInstallPath() {
        return TernNodejsCorePreferencesSupport.getInstance().getInstallPath();
    }

    private long getTimeout() {
        return TernNodejsCorePreferencesSupport.getInstance().getNodejsTimeout();
    }

    private int getTestNumber() {
        return TernNodejsCorePreferencesSupport.getInstance().getNodejsTestNumber();
    }

    private boolean isPersistent() {
        return TernNodejsCorePreferencesSupport.getInstance().isNodejsPersistent();
    }

    private String getDebugger() {
        return TernNodejsCorePreferencesSupport.getInstance().getDebugger();
    }

    private IFile getTernServerDebugFile() {
        return TernNodejsCorePreferencesSupport.getInstance().getTernServerDebugFile();
    }
}

