/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.tomcat.ui;

import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.tomcat.core.LiferayTomcatPlugin;
import com.liferay.ide.server.tomcat.core.job.CleanAppServerJob;
import com.liferay.ide.server.util.ServerUtil;
import com.liferay.ide.ui.action.AbstractObjectAction;
import java.io.FileInputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class CleanAppServerAction
extends AbstractObjectAction {
    public void run(IAction action) {
        try {
            if (!(this.fSelection instanceof IStructuredSelection)) {
                return;
            }
            Object elem = ((IStructuredSelection)this.fSelection).toArray()[0];
            if (!(elem instanceof IProject)) {
                return;
            }
            IProject project = (IProject)elem;
            SDK sdk = SDKUtil.getSDK((IProject)project);
            if (sdk == null) {
                return;
            }
            IStatus status = sdk.validate();
            if (!status.isOK()) {
                MessageDialog.openError(null, (String)Msgs.cleanAppServer, (String)status.getChildren()[0].getMessage());
                return;
            }
            Map sdkProperties = sdk.getBuildProperties();
            String bundleZipLocation = (String)sdkProperties.get("app.server.zip.name");
            status = this.validate(project, bundleZipLocation);
            if (!status.isOK()) {
                MessageDialog.openError(null, (String)Msgs.cleanAppServer, (String)status.getMessage());
                return;
            }
            this.cleanAppServer(project, bundleZipLocation);
        }
        catch (Exception ex) {
            ProjectUI.logError((Exception)ex);
        }
    }

    protected void cleanAppServer(IProject project, String bundleZipLocation) throws CoreException {
        String[] labels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
        MessageDialog dialog = new MessageDialog(this.getDisplay().getActiveShell(), this.getTitle(), null, Msgs.deleteEntireTomcatDirectory, 4, labels, 1);
        int retval = dialog.open();
        if (retval == 0) {
            new CleanAppServerJob(project, bundleZipLocation).schedule();
        }
    }

    protected void editRuntime(IRuntime runtime) {
        IRuntimeWorkingCopy runtimeWorkingCopy = runtime.createWorkingCopy();
        if (this.showWizard(runtimeWorkingCopy) != 1) {
            try {
                runtimeWorkingCopy.save(false, null);
            }
            catch (Exception exception) {}
        }
    }

    protected String getTitle() {
        return Msgs.cleanAppServer;
    }

    protected int showWizard(IRuntimeWorkingCopy runtimeWorkingCopy) {
        String title = Msgs.wizEditRuntimeWizardTitle;
        final WizardFragment fragment2 = ServerUIPlugin.getWizardFragment((String)runtimeWorkingCopy.getRuntimeType().getId());
        if (fragment2 == null) {
            return 1;
        }
        TaskModel taskModel = new TaskModel();
        taskModel.putObject("runtime", (Object)runtimeWorkingCopy);
        WizardFragment fragment = new WizardFragment(){

            protected void createChildFragments(List<WizardFragment> list) {
                list.add((WizardFragment)fragment2.getChildFragments().get(0));
                list.add(WizardTaskUtil.SaveRuntimeFragment);
            }
        };
        TaskWizard wizard = new TaskWizard(title, fragment, taskModel);
        wizard.setForcePreviousAndNextButtons(true);
        WizardDialog dialog = new WizardDialog(this.getDisplay().getActiveShell(), (IWizard)wizard);
        return dialog.open();
    }

    protected IStatus validate(IProject project, String bundleZipLocation) throws CoreException {
        IStatus result = Status.OK_STATUS;
        if (bundleZipLocation == null) {
            result = LiferayTomcatPlugin.createErrorStatus((String)Msgs.bundleZipNotdefined);
            return result;
        }
        String rootEntryName = null;
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(bundleZipLocation));
            ZipEntry rootEntry = zis.getNextEntry();
            rootEntryName = new Path(rootEntry.getName()).segment(0);
            if (rootEntryName.endsWith("/")) {
                rootEntryName = rootEntryName.substring(0, rootEntryName.length() - 1);
            }
            boolean foundBundle = false;
            ZipEntry entry = zis.getNextEntry();
            while (entry != null && !foundBundle) {
                String entryName = entry.getName();
                if (entryName.startsWith(String.valueOf(rootEntryName) + "/tomcat-")) {
                    foundBundle = true;
                } else if (entryName.startsWith(String.valueOf(rootEntryName) + "/jboss-")) {
                    foundBundle = true;
                }
                entry = zis.getNextEntry();
            }
            zis.close();
        }
        catch (Exception exception) {
            result = LiferayTomcatPlugin.createErrorStatus((String)Msgs.bundleZipLocationNotValid);
            return result;
        }
        IPath appServerDir = ServerUtil.getPortalBundle((IProject)project).getAppServerDir();
        String bundleDir = appServerDir.removeLastSegments(1).lastSegment();
        if (!bundleDir.equals(rootEntryName)) {
            result = LiferayTomcatPlugin.createErrorStatus((String)NLS.bind((String)Msgs.runtimeLocationDirectoryNotMatch, (Object)bundleDir, (Object)rootEntryName));
            return result;
        }
        return result;
    }

    private static class Msgs
    extends NLS {
        public static String bundleZipNotdefined;
        public static String bundleZipLocationNotValid;
        public static String runtimeLocationDirectoryNotMatch;
        public static String cleanAppServer;
        public static String deleteEntireTomcatDirectory;
        public static String wizEditRuntimeWizardTitle;

        static {
            Msgs.initializeMessages((String)CleanAppServerAction.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

