/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.core.resources.TernDocumentFile;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.ui.utils.EditorUtils;
import tern.server.protocol.outline.JSNode;

public class TernContentOutlinePage
extends Page
implements IContentOutlinePage {
    private final TernDocumentFile ternFile;
    private CommonViewer viewer;

    public TernContentOutlinePage(TernDocumentFile ternFile) {
        this.ternFile = ternFile;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.removePostSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.viewer.setSelection(selection);
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void createControl(Composite parent) {
        this.viewer = new CommonViewer("tern.eclipse.ide.ui.outline", parent, 2);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                JSNode node;
                IFile file;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty() && selection.getFirstElement() instanceof JSNode && (file = TernContentOutlinePage.this.getFile(node = (JSNode)selection.getFirstElement())) != null && file.exists()) {
                    Long start = node.getStart();
                    Long end = node.getEnd();
                    EditorUtils.openInEditor(file, start != null ? start.intValue() : -1, start != null && end != null ? end.intValue() - start.intValue() : -1, true);
                }
            }
        });
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.setInput((Object)this.ternFile);
    }

    private IFile getFile(JSNode node) {
        if (node.isFile()) {
            IProject project = this.ternFile.getFile().getProject();
            try {
                IIDETernProject ternProject = TernCorePlugin.getTernProject((IProject)project);
                return ternProject.getIDEFile(node.getFile());
            }
            catch (CoreException e) {
                Trace.trace((byte)3, "Error while getting tern project", e);
            }
        }
        return this.ternFile.getFile();
    }
}

