/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import tern.eclipse.ide.core.IIDETernRepository;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.Trace;
import tern.utils.TernModuleHelper;

public class ImportTernRepositoryWizardPage
extends WizardPage {
    private final IIDETernRepository repository;
    private IProjectDescription description;
    private Text nameText;
    private Text locationText;

    protected ImportTernRepositoryWizardPage(IIDETernRepository repository) {
        super("CreateOrImportProjectWizardPage");
        this.setPageComplete(true);
        this.setTitle(TernUIMessages.ImportTernRepositoryWizardPage_title);
        this.setDescription(TernUIMessages.ImportTernRepositoryWizardPage_description);
        this.repository = repository;
        this.description = this.getProjectDescription();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectInfo(workArea);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)workArea);
    }

    private void createProjectInfo(Composite parent) {
        Composite workArea = new Composite(parent, 0);
        workArea.setLayout((Layout)new GridLayout(2, false));
        workArea.setLayoutData((Object)new GridData(1808));
        Label nameLabel = new Label(workArea, 0);
        nameLabel.setText(TernUIMessages.ImportTernRepositoryWizardPage_name_label);
        this.nameText = new Text(workArea, 2052);
        this.nameText.setFont(parent.getFont());
        this.nameText.setLayoutData((Object)new GridData(768));
        Label locationLabel = new Label(workArea, 0);
        locationLabel.setText(TernUIMessages.ImportTernRepositoryWizardPage_location_label);
        this.locationText = new Text(workArea, 72);
        this.locationText.setFont(parent.getFont());
        this.locationText.setLayoutData((Object)new GridData(768));
    }

    private IProjectDescription getProjectDescription() {
        File dotProject = new File(this.repository.getBaseDir(), ".project");
        if (dotProject.exists()) {
            Path path = new Path(TernModuleHelper.getPath((File)dotProject));
            try {
                return ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
            }
            catch (CoreException e) {
                Trace.trace((byte)3, "Error while getting .project description", e);
            }
        }
        return null;
    }

    private void restoreWidgetValues() {
        if (this.description != null) {
            this.nameText.setText(this.description.getName());
            this.nameText.setEnabled(false);
        } else {
            this.nameText.setText(this.repository.getName());
        }
        this.locationText.setText(TernModuleHelper.getPath((File)this.repository.getBaseDir()));
    }

    public boolean importRepository() {
        final String projectName = this.nameText.getText();
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(projectName);
        if (project.exists()) {
            return true;
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("", 1);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IStatus status = this.importRepository(monitor);
                    if (!status.isOK()) {
                        throw new InvocationTargetException(new CoreException(status));
                    }
                }
                finally {
                    monitor.done();
                }
            }

            private IStatus importRepository(IProgressMonitor monitor) {
                if (ImportTernRepositoryWizardPage.this.description == null) {
                    ImportTernRepositoryWizardPage.this.description = workspace.newProjectDescription(projectName);
                    Path locationPath = new Path(ImportTernRepositoryWizardPage.this.repository.getBaseDir().getAbsolutePath());
                    if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                        ImportTernRepositoryWizardPage.this.description.setLocation(null);
                    } else {
                        ImportTernRepositoryWizardPage.this.description.setLocation((IPath)locationPath);
                    }
                }
                try {
                    try {
                        monitor.beginTask(TernUIMessages.ImportTernRepositoryWizardPage_CreateProjectTask, 100);
                        project.create(ImportTernRepositoryWizardPage.this.description, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                        project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 70));
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String message = TernUIMessages.ImportTernRepositoryWizardPage_errorMessage;
            Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "tern.eclipse.ide.ui", 1, message, t);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
            return false;
        }
        return true;
    }
}

