/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.search.core.AbstractRegistryManager;
import org.eclipse.wst.xml.search.core.internal.Trace;
import org.eclipse.wst.xml.search.core.internal.properties.PropertiesQuerySpecification;
import org.eclipse.wst.xml.search.core.properties.IPropertiesQuerySpecification;
import org.eclipse.wst.xml.search.core.util.StringUtils;

public class PropertiesQuerySpecificationManager
extends AbstractRegistryManager {
    private static final PropertiesQuerySpecificationManager INSTANCE = new PropertiesQuerySpecificationManager();
    private static final String RESOURCE_QUERY_SPECIFICATIONS_EXTENSION_POINT = "propertiesQuerySpecifications";
    private Map<String, IPropertiesQuerySpecification> querySpecificationsById = null;

    public static PropertiesQuerySpecificationManager getDefault() {
        return INSTANCE;
    }

    @Override
    protected void handleExtensionDelta(IExtensionDelta delta) {
        if (this.querySpecificationsById == null) {
            return;
        }
        if (delta.getKind() == 1) {
            IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
            this.addQuerySpecifications(this.querySpecificationsById, cf);
        }
    }

    public IPropertiesQuerySpecification getQuerySpecification(String querySpecificationId) {
        IPropertiesQuerySpecification querySpecification;
        if (StringUtils.isEmpty(querySpecificationId)) {
            return PropertiesQuerySpecification.DEFAULT;
        }
        if (this.querySpecificationsById == null) {
            this.loadQuerySpecifications();
        }
        if ((querySpecification = this.querySpecificationsById.get(querySpecificationId)) == null) {
            querySpecification = PropertiesQuerySpecification.DEFAULT;
            this.querySpecificationsById.put(querySpecificationId, querySpecification);
        }
        return querySpecification;
    }

    private synchronized void loadQuerySpecifications() {
        if (this.querySpecificationsById != null) {
            return;
        }
        HashMap<String, IPropertiesQuerySpecification> querySpecificationsById = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.xml.search.core", RESOURCE_QUERY_SPECIFICATIONS_EXTENSION_POINT);
            querySpecificationsById = new HashMap(cf.length);
            this.addQuerySpecifications(querySpecificationsById, cf);
        } else {
            querySpecificationsById = new HashMap<String, IPropertiesQuerySpecification>();
        }
        this.querySpecificationsById = querySpecificationsById;
        super.addRegistryListenerIfNeeded();
    }

    private synchronized void addQuerySpecifications(Map<String, IPropertiesQuerySpecification> querySpecificationsById, IConfigurationElement[] cf) {
        String id = null;
        IPropertiesQuerySpecification querySpecification = null;
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            id = ce.getAttribute("id");
            try {
                querySpecification = PropertiesQuerySpecification.newQuerySpecification(ce.createExecutableExtension("class"));
                querySpecificationsById.put(id, querySpecification);
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load querySpecification for id: " + id, t);
            }
            ++n2;
        }
    }

    @Override
    protected String getPluginId() {
        return "org.eclipse.wst.xml.search.core";
    }

    @Override
    protected String getExtensionPoint() {
        return RESOURCE_QUERY_SPECIFICATIONS_EXTENSION_POINT;
    }
}

