/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.queryspecifications.requestor;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.search.core.queryspecifications.requestor.AbstractXMLSearchRequestor;

public abstract class ContentTypeXMLSearchRequestor
extends AbstractXMLSearchRequestor {
    private Collection<String> supportedContentTypeIds;

    @Override
    public boolean accept(IFile file, IResource rootResource) {
        for (String id : this.internalGetSupportedContentTypeIds()) {
            IContentType contentType = Platform.getContentTypeManager().getContentType(id);
            if (contentType == null || !contentType.isAssociatedWith(file.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(IStructuredModel model) {
        String contentTypeIdentifier = model.getContentTypeIdentifier();
        return this.internalGetSupportedContentTypeIds().contains(contentTypeIdentifier);
    }

    private Collection<String> internalGetSupportedContentTypeIds() {
        if (this.supportedContentTypeIds == null) {
            this.supportedContentTypeIds = this.getSupportedContentTypeIds();
        }
        return this.supportedContentTypeIds;
    }

    protected abstract Collection<String> getSupportedContentTypeIds();
}

