/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.xpath.matcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.core.xpath.matcher.XPathAttributeMatcher;
import org.eclipse.wst.xml.search.core.xpath.matcher.XPathElementMatcher;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XPathMatcher
extends ArrayList<XPathElementMatcher> {
    private static final long serialVersionUID = 3057263917768550928L;
    private int nbWildCard = -1;

    public XPathMatcher(String xpathExpression) {
        this.parse(xpathExpression);
    }

    private void parse(String xpathExpression) {
        String prefix = null;
        String localName = null;
        if (xpathExpression.startsWith("/")) {
            xpathExpression = xpathExpression.substring(1, xpathExpression.length());
        }
        boolean endsWithAny = false;
        if (xpathExpression.endsWith("//")) {
            endsWithAny = true;
            xpathExpression = xpathExpression.substring(0, xpathExpression.length() - 2);
        }
        XPathElementMatcher elementmatcher = null;
        String[] paths = xpathExpression.split("/");
        int i = 0;
        while (i < paths.length) {
            localName = paths[i];
            if (StringUtils.isEmpty(localName)) {
                this.createElementMatcher();
            } else {
                int indexSquareBracket;
                int indexNS = localName.indexOf(58);
                if (indexNS != -1) {
                    prefix = localName.substring(0, indexNS);
                    localName = localName.substring(indexNS + 1, localName.length());
                }
                if ((indexSquareBracket = localName.indexOf("[")) == -1) {
                    this.createElementMatcher(prefix, localName);
                } else {
                    String elementName = localName.substring(0, indexSquareBracket);
                    elementmatcher = this.createElementMatcher(prefix, elementName);
                    String attributesCondition = localName.substring(indexSquareBracket, localName.length());
                    StringBuilder attrName = null;
                    StringBuilder attrValue = null;
                    boolean firstQuote = false;
                    boolean attrCondition = false;
                    char[] chars = attributesCondition.toCharArray();
                    int j = 0;
                    while (j < chars.length) {
                        char c = chars[j];
                        if (attrName == null) {
                            if (c != '[' && c != ']') {
                                attrName = new StringBuilder();
                                attrName.append(c);
                                attrCondition = c == '@';
                            }
                        } else if (attrValue == null) {
                            if (c != '=') {
                                attrName.append(c);
                            } else {
                                attrValue = new StringBuilder();
                            }
                        } else if (c == '\'') {
                            if (!firstQuote) {
                                firstQuote = true;
                            } else {
                                int index;
                                XPathAttributeMatcher attributematcher;
                                if (attrCondition && (attributematcher = this.createAttributeMatcher(elementmatcher, attrName.toString().substring(1, attrName.length()), attrValue.toString())).hasWildcard() && (index = attributematcher.getIndexWildcard()) > this.nbWildCard) {
                                    this.nbWildCard = index;
                                }
                                attrName = null;
                                attrValue = null;
                                firstQuote = false;
                                attrCondition = false;
                            }
                        } else {
                            attrValue.append(c);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (endsWithAny) {
            this.createElementMatcher();
        }
    }

    public boolean match(Node node) {
        return this.match(node, null);
    }

    /*
     * Unable to fully structure code
     */
    public boolean match(Node node, Collection<String> wildcardValues) {
        if (node == null) {
            return false;
        }
        testNode = node;
        condition = null;
        i = super.size() - 1;
        while (i >= 0) {
            block9: {
                block7: {
                    block8: {
                        condition = (XPathElementMatcher)super.get(i);
                        if (!condition.isAny()) break block7;
                        if (i <= 0) break block8;
                        previousConditionFounded = false;
                        previousElementCondition = (XPathElementMatcher)super.get(i - 1);
                        if (previousElementCondition != null) ** GOTO lbl18
                        return true;
lbl-1000:
                        // 1 sources

                        {
                            if (previousElementCondition.match(testNode, wildcardValues)) {
                                previousConditionFounded = true;
                                break;
                            }
                            testNode = testNode.getParentNode();
lbl18:
                            // 2 sources

                            ** while (testNode != null && testNode.getNodeType() != 9)
                        }
lbl19:
                        // 2 sources

                        if (!previousConditionFounded) {
                            return false;
                        }
                        --i;
                        break block9;
                    }
                    return true;
                }
                if (!condition.match(testNode, wildcardValues)) {
                    return false;
                }
            }
            testNode = testNode.getParentNode();
            if (testNode.getNodeName() == "#document") {
                return true;
            }
            --i;
        }
        return true;
    }

    public List<String> getWildcardValues(Node selectedNode) {
        ArrayList<String> wildcardValues = new ArrayList<String>();
        if (this.nbWildCard == -1 || selectedNode == null) {
            return wildcardValues;
        }
        Node testNode = this.getTestNode(selectedNode);
        this.match(testNode, wildcardValues);
        return wildcardValues;
    }

    private Node getTestNode(Node node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                return ((Attr)node).getOwnerElement();
            }
            case 3: {
                return ((Text)node).getParentNode();
            }
        }
        return node;
    }

    public int getNbWildCard() {
        return this.nbWildCard;
    }

    protected XPathElementMatcher createElementMatcher(String prefix, String localName) {
        XPathElementMatcher matcher = new XPathElementMatcher(prefix, localName, this);
        super.add(matcher);
        return matcher;
    }

    protected XPathElementMatcher createElementMatcher() {
        XPathElementMatcher matcher = new XPathElementMatcher(null, "*", this);
        super.add(matcher);
        return matcher;
    }

    protected XPathAttributeMatcher createAttributeMatcher(XPathElementMatcher elementmatcher, String attrName, String attrValue) {
        XPathAttributeMatcher matcher = new XPathAttributeMatcher(attrName, attrValue, this);
        elementmatcher.add(matcher);
        return matcher;
    }
}

