/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal;

import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.db.DatabaseObject;
import org.eclipse.jpt.jpa.db.internal.DTPConnectionProfileWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPDatabaseObject;
import org.eclipse.jpt.jpa.db.internal.DTPDatabaseWrapper;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DTPDatabaseObjectWrapper<P extends DTPDatabaseObject, S extends SQLObject>
implements DTPDatabaseObject {
    final P parent;
    final S dtpObject;
    private final ICatalogObjectListener catalogObjectListener;

    DTPDatabaseObjectWrapper(P parent, S dtpObject) {
        this.parent = parent;
        this.dtpObject = dtpObject;
        ICatalogObject catalogObject = this.getCatalogObject();
        if (catalogObject != null && this.getConnectionProfile().isConnected()) {
            this.catalogObjectListener = this.buildCatalogObjectListener();
            if (this.getConnectionProfile().hasAnyListeners()) {
                this.startListening(catalogObject);
            }
        } else {
            this.catalogObjectListener = null;
        }
    }

    @Override
    public String getName() {
        return this.dtpObject.getName();
    }

    @Override
    public final String getIdentifier(String defaultName) {
        return this.getDTPDriverAdapter().convertNameToIdentifier(this.getName(), defaultName);
    }

    @Override
    public final String getIdentifier() {
        return this.convertNameToIdentifier(this.getName());
    }

    String convertNameToIdentifier(String name) {
        return this.getDTPDriverAdapter().convertNameToIdentifier(name);
    }

    private ICatalogObjectListener buildCatalogObjectListener() {
        return new CatalogObjectListener();
    }

    final ICatalogObject getCatalogObject() {
        return this.dtpObject instanceof ICatalogObject ? (ICatalogObject)this.dtpObject : null;
    }

    void catalogObjectChanged() {
        this.clear();
    }

    abstract void clear();

    void startListening() {
        ICatalogObject catalogObject = this.getCatalogObject();
        if (catalogObject != null) {
            this.checkListener();
            this.startListening(catalogObject);
        }
    }

    private void startListening(ICatalogObject catalogObject) {
        RefreshManager.getInstance().AddListener(catalogObject, this.catalogObjectListener);
    }

    void stopListening() {
        ICatalogObject catalogObject = this.getCatalogObject();
        if (catalogObject != null) {
            this.checkListener();
            RefreshManager.getInstance().removeListener(catalogObject, this.catalogObjectListener);
        }
    }

    private void checkListener() {
        if (this.catalogObjectListener == null) {
            throw new IllegalStateException("the catalog listener is null");
        }
    }

    @Override
    public final DTPConnectionProfileWrapper getConnectionProfile() {
        return this.parent.getConnectionProfile();
    }

    @Override
    public DTPDatabaseWrapper getDatabase() {
        return this.parent.getDatabase();
    }

    @Override
    public final void refresh() {
        ICatalogObject catalogObject = this.getCatalogObject();
        if (catalogObject != null) {
            catalogObject.refresh();
        }
    }

    DTPDriverAdapter getDTPDriverAdapter() {
        return this.getDatabase().getDTPDriverAdapter();
    }

    final <T extends DatabaseObject> T selectDatabaseObjectNamed(Iterable<T> databaseObjects, String name) {
        for (DatabaseObject databaseObject : databaseObjects) {
            if (!databaseObject.getName().equals(name)) continue;
            return (T)databaseObject;
        }
        return null;
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (CharSequence)this.getName());
    }

    class CatalogObjectListener
    implements ICatalogObjectListener {
        CatalogObjectListener() {
        }

        public void notifyChanged(ICatalogObject dmElement, int eventType) {
            DTPDatabaseObjectWrapper.this.catalogObjectChanged();
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }
}

