/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import com.liferay.ide.core.LiferayNature;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.gradle.toolingapi.custom.CustomModel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.event.Event;
import org.eclipse.buildship.core.event.EventListener;
import org.eclipse.buildship.core.workspace.ProjectCreatedEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.osgi.framework.BundleContext;

public class GradleCore
extends Plugin
implements EventListener {
    private static GradleCore plugin;
    public static final String PLUGIN_ID = "com.liferay.ide.gradle.core";

    public static IStatus createErrorStatus(Exception ex) {
        return new Status(4, PLUGIN_ID, ex.getMessage(), (Throwable)ex);
    }

    public static IStatus createErrorStatus(String msg) {
        return new Status(4, PLUGIN_ID, msg);
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        return new Status(4, PLUGIN_ID, msg, (Throwable)e);
    }

    public static IStatus createWarningStatus(String msg) {
        return new Status(2, PLUGIN_ID, msg);
    }

    public static GradleCore getDefault() {
        return plugin;
    }

    public static <T> T getToolingModel(Class<T> modelClass, IProject gradleProject) {
        return GradleCore.getToolingModel(modelClass, gradleProject.getLocation().toFile());
    }

    public static <T> T getToolingModel(Class<T> modelClass, File projectDir) {
        Object retval = null;
        try {
            GradleConnector connector = GradleConnector.newConnector();
            connector.forProjectDirectory(projectDir);
            try (ProjectConnection connection = null;){
                connection = connector.connect();
                ModelBuilder modelBuilder = connection.model(modelClass);
                File localRepo = new File(FileLocator.toFileURL((URL)GradleCore.getDefault().getBundle().getEntry("repo")).getFile());
                String initScriptTemplate = CoreUtil.readStreamToString((InputStream)new FileInputStream(new File(localRepo, "init.gradle")));
                String path = localRepo.getAbsolutePath();
                path = path.replaceAll("\\\\", "/");
                String initScriptContents = initScriptTemplate.replaceFirst("%repo%", path);
                IPath scriptPath = GradleCore.getDefault().getStateLocation().append("init.gradle");
                File scriptFile = scriptPath.toFile();
                FileUtil.writeFileFromStream((File)scriptFile, (InputStream)new ByteArrayInputStream(initScriptContents.getBytes()));
                modelBuilder.withArguments(new String[]{"--init-script", scriptFile.getAbsolutePath()});
                retval = modelBuilder.get();
            }
        }
        catch (Exception e) {
            GradleCore.logError("Error getting tooling model", e);
        }
        return (T)retval;
    }

    public static void logError(Exception ex) {
        GradleCore.getDefault().getLog().log(GradleCore.createErrorStatus(ex));
    }

    public static void logError(String msg) {
        GradleCore.getDefault().getLog().log(GradleCore.createErrorStatus(msg));
    }

    public static void logError(String msg, Exception e) {
        GradleCore.getDefault().getLog().log(GradleCore.createErrorStatus(msg, e));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        CorePlugin.listenerRegistry().addEventListener((EventListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        CorePlugin.listenerRegistry().removeEventListener((EventListener)this);
    }

    public void onEvent(Event event) {
        if (event instanceof ProjectCreatedEvent) {
            NullProgressMonitor npm = new NullProgressMonitor();
            ProjectCreatedEvent projectCreatedEvent = (ProjectCreatedEvent)event;
            IProject project = projectCreatedEvent.getProject();
            if (!LiferayNature.hasNature((IProject)project)) {
                try {
                    CustomModel customModel = GradleCore.getToolingModel(CustomModel.class, project);
                    if (customModel.hasPlugin("aQute.bnd.gradle.BndBuilderPlugin") || customModel.hasPlugin("com.liferay.gradle.plugins.LiferayPlugin") || customModel.hasPlugin("com.liferay.gradle.plugins.gulp.GulpPlugin")) {
                        LiferayNature.addLiferayNature((IProject)project, (IProgressMonitor)npm);
                    }
                }
                catch (Exception e) {
                    GradleCore.logError("Unable to get tooling model", e);
                }
            }
        }
    }

    public static Object getProjectInfoFromDir(File file) {
        CustomModel model = GradleCore.getToolingModel(CustomModel.class, file);
        Set files = model.getOutputFiles();
        return files;
    }
}

