/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.facet;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileListing;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.facet.IPluginProjectDataModelProperties;
import com.liferay.ide.sdk.core.ISDKConstants;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public abstract class PluginFacetInstall
implements IDelegate,
IPluginProjectDataModelProperties {
    protected static final String DEFAULT_DEPLOY_PATH = "/WEB-INF/classes";
    private static final String PATH_IN_PROJECT = ".settings/org.eclipse.wst.common.project.facet.core.prefs.xml";
    protected IDataModel masterModel = null;
    protected IDataModel model = null;
    protected IProgressMonitor monitor;
    protected IProject project;

    protected void configureDeploymentAssembly(String srcPath, String deployPath) {
        IVirtualComponent vProject = ComponentCore.createComponent((IProject)this.project);
        IVirtualFolder vProjectFolder = vProject.getRootFolder();
        IVirtualFolder deployFolder = vProjectFolder.getFolder((IPath)new Path(deployPath));
        try {
            deployFolder.createLink((IPath)new Path(srcPath), 1, null);
        }
        catch (CoreException e) {
            ProjectCore.logError("Unable to create link", (Exception)((Object)e));
        }
        try {
            IPath outputLocation = JavaCore.create((IProject)this.project).getOutputLocation();
            vProject.setMetaProperty("java-output-path", outputLocation.toPortableString());
        }
        catch (JavaModelException e) {
            ProjectCore.logError("Unable to set java-ouput-path", (Exception)((Object)e));
        }
    }

    protected void copyToProject(IPath parent, File newFile) throws CoreException, IOException {
        if (newFile == null || !this.shouldCopyToProject(newFile)) {
            return;
        }
        Object projectEntry = null;
        Path newFilePath = new Path(newFile.getPath());
        IPath newFileRelativePath = newFilePath.makeRelativeTo(parent);
        projectEntry = newFile.isDirectory() ? this.project.getFolder(newFileRelativePath) : this.project.getFile(newFileRelativePath);
        if (projectEntry.exists()) {
            if (projectEntry instanceof IFolder) {
                return;
            }
            if (projectEntry instanceof IFile) {
                ((IFile)projectEntry).setContents((InputStream)new FileInputStream(newFile), 1, null);
            }
        } else if (projectEntry instanceof IFolder) {
            IFolder newProjectFolder = projectEntry;
            newProjectFolder.create(true, true, null);
        } else if (projectEntry instanceof IFile) {
            ((IFile)projectEntry).create((InputStream)new FileInputStream(newFile), 1, null);
        }
    }

    protected boolean deletePath(IPath path) {
        if (path != null && path.toFile().exists()) {
            return path.toFile().delete();
        }
        return false;
    }

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (!(config instanceof IDataModel)) {
            return;
        }
        this.model = (IDataModel)config;
        this.masterModel = (IDataModel)this.model.getProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM");
        this.project = project;
        this.monitor = monitor;
        try {
            IFile f = this.project.getProject().getFile(PATH_IN_PROJECT);
            File file = f.getLocation().toFile();
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot wsroot = ws.getRoot();
            Path path = new Path(file.getAbsolutePath());
            Object[] wsFiles = wsroot.findFilesForLocationURI(path.toFile().toURI());
            if (!CoreUtil.isNullOrEmpty((Object[])wsFiles)) {
                Object[] objectArray = wsFiles;
                int n = wsFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    Object wsFile = objectArray[n2];
                    wsFile.getParent().getParent().refreshLocal(2, null);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {}
        if (this.shouldInstallPluginLibraryDelegate()) {
            this.installPluginLibraryDelegate();
        }
        if (this.shouldSetupDefaultOutputLocation()) {
            this.setupDefaultOutputLocation();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPath outputLocation = project.getFolder(this.getDefaultOutputLocation()).getFullPath();
            javaProject.setOutputLocation(outputLocation, monitor);
        }
    }

    protected IPath getAppServerDir() {
        IRuntime serverRuntime = this.masterModel != null ? (IRuntime)this.masterModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME") : this.getFacetedProject().getPrimaryRuntime();
        return ServerUtil.getAppServerDir((IRuntime)serverRuntime);
    }

    protected abstract String getDefaultOutputLocation();

    protected IDataModel getFacetDataModel(String facetId) {
        IFacetedProjectWorkingCopy fp = this.getFacetedProject();
        for (IProjectFacetVersion pfv : fp.getProjectFacets()) {
            IFacetedProject.Action action;
            if (!pfv.getProjectFacet().getId().equals(facetId) || (action = fp.getProjectFacetAction(pfv.getProjectFacet())) == null) continue;
            Object config = action.getConfig();
            return (IDataModel)Platform.getAdapterManager().getAdapter(config, IDataModel.class);
        }
        return null;
    }

    protected IFacetedProjectWorkingCopy getFacetedProject() {
        return (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
    }

    protected String getRuntimeLocation() {
        try {
            return ServerUtil.getRuntime((IProject)this.project).getLocation().toOSString();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected SDK getSDK() {
        String sdkName = null;
        try {
            sdkName = this.masterModel.getStringProperty("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME");
        }
        catch (Exception exception) {}
        if (sdkName == null) {
            try {
                sdkName = this.model.getStringProperty("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME");
            }
            catch (Exception exception) {}
        }
        return SDKManager.getInstance().getSDK(sdkName);
    }

    protected IFolder getWebRootFolder() {
        IDataModel webFacetDataModel = null;
        if (this.masterModel != null) {
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.masterModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            webFacetDataModel = map.getFacetDataModel(IJ2EEFacetConstants.DYNAMIC_WEB_FACET.getId());
        } else {
            webFacetDataModel = this.getFacetDataModel("jst.web");
        }
        IPath webrootFullPath = null;
        if (webFacetDataModel != null) {
            webrootFullPath = this.project.getFullPath().append(webFacetDataModel.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER"));
        } else {
            IVirtualComponent component = ComponentCore.createComponent((IProject)this.project);
            if (component != null) {
                webrootFullPath = component.getRootFolder().getUnderlyingFolder().getFullPath();
            }
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(webrootFullPath);
    }

    protected void installPluginLibraryDelegate() throws CoreException {
        LibraryInstallDelegate libraryDelegate = (LibraryInstallDelegate)this.model.getProperty("IPluginProjectDataModelProperties.LIFERAY_PLUGIN_LIBRARY_DELEGATE");
        libraryDelegate.execute(this.monitor);
    }

    protected boolean isProjectInSDK() {
        return this.masterModel.getBooleanProperty("IPluginProjectDataModelProperties.LIFERAY_USE_SDK_LOCATION");
    }

    protected void processNewFiles(IPath path) throws CoreException {
        try {
            List newFiles = FileListing.getFileListing((File)path.toFile());
            for (File file : newFiles) {
                try {
                    this.copyToProject(path, file);
                }
                catch (Exception e) {
                    ProjectCore.logError(e);
                }
            }
        }
        catch (FileNotFoundException e1) {
            throw new CoreException(ProjectCore.createErrorStatus(e1));
        }
    }

    protected void setupDefaultOutputLocation() throws CoreException {
        IJavaProject jProject = JavaCore.create((IProject)this.project);
        IFolder folder = this.project.getFolder(this.getDefaultOutputLocation());
        if (folder.getParent().exists()) {
            CoreUtil.prepareFolder((IFolder)folder);
            IPath oldOutputLocation = jProject.getOutputLocation();
            IFolder oldOutputFolder = CoreUtil.getWorkspaceRoot().getFolder(oldOutputLocation);
            jProject.setOutputLocation(folder.getFullPath(), null);
            try {
                if (!folder.equals((Object)oldOutputFolder) && oldOutputFolder.exists()) {
                    IContainer outputParent = oldOutputFolder.getParent();
                    oldOutputFolder.delete(true, null);
                    if (outputParent.members().length == 0 && outputParent.getName().equals("build")) {
                        outputParent.delete(true, null);
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    protected boolean shouldConfigureDeploymentAssembly() {
        return this.model.getBooleanProperty("IPluginProjectDataModelProperties.CONFIGURE_DEPLOYMENT_ASSEMBLY");
    }

    protected boolean shouldCopyToProject(File file) {
        if (this.isProjectInSDK()) {
            return true;
        }
        String[] stringArray = ISDKConstants.PORTLET_PLUGIN_ZIP_IGNORE_FILES;
        int n = ISDKConstants.PORTLET_PLUGIN_ZIP_IGNORE_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (file.getName().equals(name)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean shouldInstallPluginLibraryDelegate() {
        return this.model.getBooleanProperty("IPluginProjectDataModelProperties.INSTALL_LIFERAY_PLUGIN_LIBRARY_DELEGATE");
    }

    protected boolean shouldSetupDefaultOutputLocation() {
        return this.model.getBooleanProperty("IPluginProjectDataModelProperties.SETUP_DEFAULT_OUTPUT_LOCATION");
    }

    protected boolean shouldSetupExtClasspath() {
        return this.model.getBooleanProperty("IPluginProjectDataModelProperties.SETUP_EXT_CLASSPATH");
    }
}

