/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.ddl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.datatools.enablement.ibm.db2.ddl.DB2DdlBuilder;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Column;
import org.eclipse.datatools.enablement.ibm.db2.model.GenerateType;
import org.eclipse.datatools.enablement.ibm.ddl.DdlGenerationUtility;
import org.eclipse.datatools.enablement.ibm.util.SimpleColumnDetails;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpression;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;

public class DB2DataPreservationDdlBuilder
extends DB2DdlBuilder {
    protected static final String COMMENT_DELIMITER = "--";
    protected static final String RENAME = "RENAME";
    protected static final String INSERT = "INSERT";
    protected static final String INTO = "INTO";
    protected static final String SELECT = "SELECT";
    protected static final String BACKUP_SUFFIX = "_BU";
    protected static final String DECIMAL = "DECIMAL";
    protected static final String REAL = "REAL";
    protected static final String INTEGER = "INTEGER";
    protected static final String BIGINT = "BIGINT";
    protected static final String SMALLINT = "SMALLINT";
    protected static final String GRAPHIC = "GRAPHIC";
    protected static final String CHAR = "CHAR";
    protected static final String TIMESTAMP = "TIMESTAMP";
    protected static final String TIME = "TIME";
    protected static final String DATE = "DATE";
    protected static final String DOUBLE = "DOUBLE";
    protected static final String XML = "XML";
    protected static final String RENAME_TABLE_COMMENT = "Renaming table to maintain a backup";
    protected static final String POPULATE_COMMENT = "Populating table from backup using optimistic transformations";
    protected static final String RESTART_IDENTITY_COMMENT = "Replace <restart value placeholder> with an appropriate value";
    protected static final String DROP_BACKUP_COMMENT = "Dropping backup table";
    protected static final String UPDATE_NULL_COLUMNS_COMMENT = "Update columns changed to NOT NULL with default";
    protected Map backupTableMap = new HashMap();

    protected String getNewBackupName(Table table, boolean quoteIdentifiers, boolean qualifyNames) {
        String tableNamePrefix = String.valueOf(table.getName()) + BACKUP_SUFFIX;
        Schema schema = table.getSchema();
        String schemaName = schema.getName();
        String tableName = DdlGenerationUtility.getUniqueTableName((Schema)schema, (String)tableNamePrefix);
        this.backupTableMap.put(tableNamePrefix, tableName);
        if (quoteIdentifiers) {
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            tableName = String.valueOf(schemaName) + "." + tableName;
        }
        return tableName;
    }

    protected String getExistingBackupName(String schemaName, String tablename, boolean quoteIdentifiers, boolean qualifyNames) {
        String tableNamePrefix = String.valueOf(tablename) + BACKUP_SUFFIX;
        String tableName = (String)this.backupTableMap.get(tableNamePrefix);
        if (quoteIdentifiers) {
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            tableName = String.valueOf(schemaName) + "." + tableName;
        }
        return tableName;
    }

    public String renameTableToBackup(Table table, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "RENAME TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + " " + "TO" + " ";
        String backupTableName = this.getNewBackupName(table, quoteIdentifiers, false);
        return String.valueOf(statement) + backupTableName;
    }

    public String getRenameComment() {
        return String.valueOf(NEWLINE) + COMMENT_DELIMITER + " " + RENAME_TABLE_COMMENT;
    }

    public String getUpdateComment() {
        return String.valueOf(NEWLINE) + COMMENT_DELIMITER + " " + UPDATE_NULL_COLUMNS_COMMENT;
    }

    public String getSuspendGenerateAlwaysStatement(Table newTable, Column idColumn, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = null;
        statement = idColumn.getIdentitySpecifier() != null ? "ALTER TABLE " + this.getName(newTable, quoteIdentifiers, qualifyNames) + " " + "ALTER" + " " + "COLUMN" + " " + this.getName(idColumn, quoteIdentifiers, false) + " SET GENERATED BY DEFAULT" : "ALTER TABLE " + this.getName(newTable, quoteIdentifiers, qualifyNames) + " " + "ALTER" + " " + "COLUMN" + " " + this.getName(idColumn, quoteIdentifiers, false) + " DROP EXPRESSION";
        return statement;
    }

    public String getSetGenerateAlwaysStatement(Table newTable, Column idColumn, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "ALTER TABLE " + this.getName(newTable, quoteIdentifiers, qualifyNames) + " " + "ALTER" + " " + "COLUMN" + " " + this.getName(idColumn, quoteIdentifiers, false) + " SET GENERATED ALWAYS";
        ValueExpression genExp = idColumn.getGenerateExpression();
        if (genExp != null) {
            statement = String.valueOf(statement) + " AS (" + genExp.getSQL() + ")";
        }
        return statement;
    }

    public String getRestartIdentityComment() {
        return String.valueOf(NEWLINE) + COMMENT_DELIMITER + " " + RESTART_IDENTITY_COMMENT;
    }

    public String getRestartIdentityStatement(Table newTable, Column idColumn, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "-- ALTER TABLE " + this.getName(newTable, quoteIdentifiers, qualifyNames) + " " + "ALTER" + " " + "COLUMN" + " " + this.getName(idColumn, quoteIdentifiers, false) + " RESTART WITH " + "<restart value placeholder>";
        return statement;
    }

    public ArrayList getAlwaysGeneratedColumns(Table table) {
        ArrayList<DB2Column> genColumns = new ArrayList<DB2Column>();
        for (DB2Column column : table.getColumns()) {
            if (column.getGenerationType() != GenerateType.ALWAYS_LITERAL || column.getGenerateExpression() == null && column.getIdentitySpecifier() == null) continue;
            genColumns.add(column);
        }
        return genColumns;
    }

    public String populateTableFromBackup(Table newTable, String oldTableName, Map oldColumns, boolean quoteIdentifiers, boolean qualifyNames) {
        Column newColumn;
        StringBuffer statement = new StringBuffer("-- INSERT INTO " + this.getName(newTable, quoteIdentifiers, qualifyNames) + "(");
        Iterator it = newTable.getColumns().iterator();
        boolean firstColumn = true;
        while (it.hasNext()) {
            newColumn = (Column)it.next();
            SimpleColumnDetails oldColDetails = (SimpleColumnDetails)oldColumns.get(newColumn);
            if (oldColDetails == null) continue;
            if (!firstColumn) {
                statement.append(", ");
            }
            firstColumn = false;
            statement.append(this.getName(newColumn, quoteIdentifiers, false));
        }
        statement.append(") SELECT ");
        it = newTable.getColumns().iterator();
        firstColumn = true;
        while (it.hasNext()) {
            newColumn = (Column)it.next();
            SimpleColumnDetails newColDetails = new SimpleColumnDetails(newColumn);
            SimpleColumnDetails oldColDetails = (SimpleColumnDetails)oldColumns.get(newColumn);
            if (oldColDetails == null) continue;
            if (!firstColumn) {
                statement.append(", ");
            }
            firstColumn = false;
            String xformedColumn = this.getXformBackupColumn(quoteIdentifiers ? this.getDoubleQuotedString(oldColDetails.name) : oldColDetails.name, oldColDetails.type, newColDetails.type, oldColDetails.length, newColDetails.length, oldColDetails.scale, newColDetails.scale);
            statement.append(xformedColumn);
        }
        statement.append(" FROM " + this.getExistingBackupName(newTable.getSchema().getName(), oldTableName, quoteIdentifiers, qualifyNames));
        return statement.toString();
    }

    public String getPopulateComment() {
        return String.valueOf(NEWLINE) + COMMENT_DELIMITER + " " + POPULATE_COMMENT;
    }

    public String dropBackupTable(Table oldTable, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = new StringBuffer("-- DROP TABLE ");
        statement.append(this.getExistingBackupName(oldTable.getSchema().getName(), oldTable.getName(), quoteIdentifiers, qualifyNames));
        return statement.toString();
    }

    public String dropBackupTable(String oldSchema, String oldName, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = new StringBuffer("-- DROP TABLE ");
        statement.append(this.getExistingBackupName(oldSchema, oldName, quoteIdentifiers, qualifyNames));
        return statement.toString();
    }

    public String getDropBackupComment() {
        return String.valueOf(NEWLINE) + COMMENT_DELIMITER + " " + DROP_BACKUP_COMMENT;
    }

    public String getXformBackupColumn(String backupColumnName, String type1, String type2, int length1, int length2, int scale1, int scale2) {
        if (type1.equals(SMALLINT)) {
            if (this.isCharacterStringType(type2)) {
                return this.getGeneratedNumberToStringXformExpression(backupColumnName, type2, length2);
            }
            if (type2.equals(DECIMAL)) {
                return this.getGeneratedDecimalFunctionExpression(backupColumnName, length2, scale2);
            }
        } else if (type1.equals(INTEGER)) {
            if (this.isCharacterStringType(type2)) {
                return this.getGeneratedNumberToStringXformExpression(backupColumnName, type2, length2);
            }
            if (type2.equals(SMALLINT) || type2.equals(REAL)) {
                return this.getGeneratedScalarFunctionExpression(type2, backupColumnName);
            }
            if (type2.equals(DECIMAL)) {
                return this.getGeneratedDecimalFunctionExpression(backupColumnName, length2, scale2);
            }
        } else if (type1.equals(BIGINT)) {
            if (this.isCharacterStringType(type2)) {
                return this.getGeneratedNumberToStringXformExpression(backupColumnName, type2, length2);
            }
            if (type2.equals(SMALLINT) || type2.equals(INTEGER) || type2.equals(REAL)) {
                return this.getGeneratedScalarFunctionExpression(type2, backupColumnName);
            }
            if (type2.equals(DECIMAL)) {
                return this.getGeneratedDecimalFunctionExpression(backupColumnName, length2, scale2);
            }
        } else if (type1.equals(REAL)) {
            if (this.isCharacterStringType(type2)) {
                return this.getGeneratedNumberToStringXformExpression(backupColumnName, type2, length2);
            }
            if (type2.equals(SMALLINT) || type2.equals(INTEGER) || type2.equals(BIGINT)) {
                return this.getGeneratedScalarFunctionExpression(type2, backupColumnName);
            }
            if (type2.equals(DECIMAL)) {
                return this.getGeneratedDecimalFunctionExpression(backupColumnName, length2, scale2);
            }
        } else if (type1.equals(DOUBLE)) {
            if (this.isCharacterStringType(type2)) {
                return this.getGeneratedNumberToStringXformExpression(backupColumnName, type2, length2);
            }
            if (type2.equals(REAL) || type2.equals(SMALLINT) || type2.equals(INTEGER) || type2.equals(BIGINT)) {
                return this.getGeneratedScalarFunctionExpression(type2, backupColumnName);
            }
            if (type2.equals(DECIMAL)) {
                return this.getGeneratedDecimalFunctionExpression(backupColumnName, length2, scale2);
            }
        } else if (type1.equals(DECIMAL)) {
            if (this.isCharacterStringType(type2)) {
                return this.getGeneratedNumberToStringXformExpression(backupColumnName, type2, length2);
            }
            if (type2.equals(REAL) || type2.equals(SMALLINT) || type2.equals(INTEGER) || type2.equals(BIGINT)) {
                return this.getGeneratedScalarFunctionExpression(type2, backupColumnName);
            }
            if (type2.equals(DECIMAL) && (length1 != length2 || scale1 != scale2)) {
                return this.getGeneratedDecimalFunctionExpression(backupColumnName, length2, scale2);
            }
        } else if (type1.equals(DATE)) {
            if (this.isCharacterStringType(type2)) {
                return this.getGeneratedNumberToStringXformExpression(backupColumnName, type2, length2);
            }
        } else if (type1.equals(TIME)) {
            if (this.isCharacterStringType(type2)) {
                return this.getGeneratedNumberToStringXformExpression(backupColumnName, type2, length2);
            }
        } else if (type1.equals(TIMESTAMP)) {
            if (this.isCharacterStringType(type2)) {
                return this.getGeneratedNumberToStringXformExpression(backupColumnName, type2, length2);
            }
            if (type2.equals(DATE) || type2.equals(TIME)) {
                return this.getGeneratedScalarFunctionExpression(type2, backupColumnName);
            }
        } else if (type1.equals(CHAR)) {
            if ((type2.equals(CHAR) && length2 < length1 || type2.equals("VARCHAR")) && length2 < length1) {
                return this.getGeneratedScalarFunctionExpression("RTRIM", backupColumnName);
            }
            if (type2.equals(GRAPHIC) || type2.equals("VARGRAPHIC")) {
                return this.getGeneratedScalarFunctionExpression(GRAPHIC, this.getGeneratedScalarFunctionExpression("RTRIM", backupColumnName));
            }
            if (type2.equals("CLOB") || type2.equals("DBCLOB")) {
                return this.getGeneratedScalarFunctionExpression(type2, this.getGeneratedScalarFunctionExpression("RTRIM", backupColumnName));
            }
            if (type2.equals(SMALLINT) || type2.equals(INTEGER) || type2.equals(BIGINT) || type2.equals(REAL) || type2.equals(DOUBLE)) {
                return this.getGeneratedScalarFunctionExpression(type2, backupColumnName);
            }
            if (type2.equals(DECIMAL)) {
                return this.getGeneratedDecimalFunctionExpression(backupColumnName, length2, scale2);
            }
            if (type2.equals(DATE) || type2.equals(TIME) || type2.equals(TIMESTAMP)) {
                return this.getGeneratedScalarFunctionExpression(type2, this.getGeneratedScalarFunctionExpression("RTRIM", backupColumnName));
            }
        } else if (type1.equals("VARCHAR")) {
            if (type2.equals("CLOB") || type2.equals("DBCLOB")) {
                return this.getGeneratedScalarFunctionExpression(type2, backupColumnName);
            }
            if (type2.equals(SMALLINT) || type2.equals(INTEGER) || type2.equals(BIGINT) || type2.equals(REAL) || type2.equals(DOUBLE)) {
                return this.getGeneratedScalarFunctionExpression(type2, backupColumnName);
            }
            if (type2.equals(DECIMAL)) {
                return this.getGeneratedDecimalFunctionExpression(backupColumnName, length2, scale2);
            }
            if (type2.equals(DATE) || type2.equals(TIME) || type2.equals(TIMESTAMP)) {
                return this.getGeneratedScalarFunctionExpression(type2, backupColumnName);
            }
        } else if (type1.equals(GRAPHIC)) {
            if (type2.equals(CHAR) || type2.equals("VARCHAR")) {
                return this.getGeneratedScalarFunctionExpression(CHAR, this.getGeneratedScalarFunctionExpression("RTRIM", backupColumnName));
            }
            if (type2.equals(GRAPHIC) && length2 < length1 || type2.equals("VARGRAPHIC")) {
                return this.getGeneratedScalarFunctionExpression("RTRIM", backupColumnName);
            }
            if (type2.equals("CLOB") || type2.equals("DBCLOB")) {
                return this.getGeneratedScalarFunctionExpression(type2, this.getGeneratedScalarFunctionExpression("RTRIM", backupColumnName));
            }
            if (type2.equals(SMALLINT) || type2.equals(INTEGER) || type2.equals(BIGINT) || type2.equals(REAL) || type2.equals(DOUBLE)) {
                return this.getGeneratedScalarFunctionExpression(type2, this.getGeneratedScalarFunctionExpression(CHAR, backupColumnName));
            }
            if (type2.equals(DECIMAL)) {
                return this.getGeneratedDecimalFunctionExpression(this.getGeneratedScalarFunctionExpression(CHAR, backupColumnName), length2, scale2);
            }
            if (type2.equals(DATE) || type2.equals(TIME) || type2.equals(TIMESTAMP)) {
                return this.getGeneratedScalarFunctionExpression(type2, this.getGeneratedScalarFunctionExpression("RTRIM", backupColumnName));
            }
        } else if (type1.equals("VARGRAPHIC")) {
            if (type2.equals("CLOB") || type2.equals("DBCLOB")) {
                return this.getGeneratedScalarFunctionExpression(type2, backupColumnName);
            }
            if (type2.equals(SMALLINT) || type2.equals(INTEGER) || type2.equals(BIGINT) || type2.equals(REAL) || type2.equals(DOUBLE)) {
                return this.getGeneratedScalarFunctionExpression(type2, this.getGeneratedScalarFunctionExpression(CHAR, backupColumnName));
            }
            if (type2.equals(DECIMAL)) {
                return this.getGeneratedDecimalFunctionExpression(this.getGeneratedScalarFunctionExpression(CHAR, backupColumnName), length2, scale2);
            }
            if (type2.equals(DATE) || type2.equals(TIME) || type2.equals(TIMESTAMP)) {
                return this.getGeneratedScalarFunctionExpression(type2, backupColumnName);
            }
        } else if (type1.equals(XML)) {
            return this.getGeneratedXmlXformExpression(backupColumnName, type2);
        }
        return backupColumnName;
    }

    private String getGeneratedNumberToStringXformExpression(String colName, String type, int length) {
        if (this.isFixedLengthStringType(type)) {
            return this.getGeneratedScalarFunctionExpression(type, this.getGeneratedScalarFunctionExpression(type, colName, String.valueOf(length)));
        }
        if (this.isLOBType(type)) {
            if (this.isDoubleByteType(type)) {
                return this.getGeneratedScalarFunctionExpression(type, this.getGeneratedScalarFunctionExpression("VARGRAPHIC", colName));
            }
            return this.getGeneratedScalarFunctionExpression(type, this.getGeneratedScalarFunctionExpression("VARCHAR", colName));
        }
        return this.getGeneratedScalarFunctionExpression(type, colName);
    }

    private String getGeneratedScalarFunctionExpression(String function, String parm1, String parm2) {
        return String.valueOf(function) + "(" + parm1 + ", " + parm2 + ")";
    }

    private String getGeneratedDecimalFunctionExpression(String parm, int precision, int scale) {
        return "DECIMAL(" + parm + ", " + String.valueOf(precision) + ", " + String.valueOf(scale) + ")";
    }

    private String getGeneratedScalarFunctionExpression(String function, String parm) {
        return String.valueOf(function) + "(" + parm + ")";
    }

    protected String getGeneratedXmlXformExpression(String backupColName, String type2) {
        if (this.isCharacterStringType(type2) && !this.isDoubleByteType(type2)) {
            return "XMLSERIALIZE (" + backupColName + " AS " + type2 + ")";
        }
        return backupColName;
    }

    private boolean isCharacterStringType(String type) {
        return type.equals(CHAR) || type.equals("VARCHAR") || type.equals(GRAPHIC) || type.equals("VARGRAPHIC") || type.equals("CLOB") || type.equals("DBCLOB");
    }

    private boolean isDoubleByteType(String type) {
        return type.equals(GRAPHIC) || type.equals("VARGRAPHIC") || type.equals("DBCLOB");
    }

    private boolean isLOBType(String type) {
        return type.equals("CLOB") || type.equals("BLOB") || type.equals("DBCLOB");
    }

    private boolean isFixedLengthStringType(String type) {
        return type.equals(CHAR) || type.equals(GRAPHIC);
    }
}

