/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.eclipse;

import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;

public class IvyNatureHelper {
    public static final String IVY_NATURE_ID = "org.apache.ivyde.eclipse.ivynature";

    private IvyNatureHelper() {
    }

    public static boolean hasNature(IProject project) {
        try {
            return project.hasNature(IVY_NATURE_ID);
        }
        catch (CoreException e) {
            IvyPlugin.logError("Unable to get the Ivy nature of the project " + project.getName(), e);
            return false;
        }
    }

    public static void addNature(final IProject project) {
        IProjectDescription description;
        if (IvyNatureHelper.hasNature(project)) {
            return;
        }
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            IvyPlugin.logError("Failed to add Ivy dependency management on " + project.getName(), e);
            return;
        }
        String[] ids = description.getNatureIds();
        String[] newIds = new String[ids == null ? 1 : ids.length + 1];
        if (ids != null) {
            System.arraycopy(ids, 0, newIds, 0, ids.length);
        }
        newIds[ids == null ? 0 : ids.length] = IVY_NATURE_ID;
        description.setNatureIds(newIds);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    project.setDescription(description, null);
                }
                catch (CoreException e) {
                    IvyPlugin.logError("Failed to add Ivy dependency management on " + project.getName(), e);
                }
            }
        });
    }

    public static void removeNature(IProject project) {
        try {
            if (!IvyNatureHelper.hasNature(project)) {
                return;
            }
            IProjectDescription description = project.getDescription();
            String[] ids = description.getNatureIds();
            if (ids == null || ids.length == 0) {
                return;
            }
            int i = 0;
            while (i < ids.length) {
                if (IVY_NATURE_ID.equals(ids[i])) break;
                ++i;
            }
            if (i == ids.length) {
                return;
            }
            String[] newIds = new String[ids.length - 1];
            if (i > 0) {
                System.arraycopy(ids, 0, newIds, 0, i);
            }
            if (i < ids.length - 1) {
                System.arraycopy(ids, i + 1, newIds, i, ids.length - i - 1);
            }
            description.setNatureIds(newIds);
            project.setDescription(description, null);
        }
        catch (Exception e) {
            IvyPlugin.logError("Failed to remove Ivy dependency management on " + project.getName(), e);
        }
    }
}

