/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.eclipse.cp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.ivyde.eclipse.IvyDEException;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainer;
import org.apache.ivyde.eclipse.cp.ResolvedPath;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class IvyClasspathContainerHelper {
    static /* synthetic */ Class class$0;

    private IvyClasspathContainerHelper() {
    }

    public static IvyClasspathContainer getContainer(IStructuredSelection selection) {
        if (selection == null) {
            return null;
        }
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            IvyClasspathContainerImpl cp;
            Object element = it.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((cp = (IvyClasspathContainerImpl)IvyPlugin.adapt(element, clazz)) != null) {
                return cp;
            }
            if (!(element instanceof ClassPathContainer)) continue;
            return IvyClasspathUtil.jdt2IvyCPC((ClassPathContainer)element);
        }
        return null;
    }

    public static boolean isIvyClasspathContainer(IPath containerPath) {
        return containerPath.segment(0).equals("org.apache.ivyde.eclipse.cpcontainer.IVYDE_CONTAINER");
    }

    public static List getContainers(IJavaProject javaProject) {
        ArrayList<IClasspathContainer> containers = new ArrayList<IClasspathContainer>();
        if (javaProject == null || !javaProject.exists()) {
            return containers;
        }
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathContainer cp;
                IPath path;
                IClasspathEntry entry = entries[i];
                if (entry != null && entry.getEntryKind() == 5 && IvyClasspathContainerHelper.isIvyClasspathContainer(path = entry.getPath()) && (cp = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)javaProject)) instanceof IvyClasspathContainerImpl) {
                    containers.add(cp);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            IvyPlugin.log((CoreException)((Object)e));
        }
        return containers;
    }

    public static List getContainersFromIvyFile(IFile ivyfile) {
        IJavaProject javaProject = JavaCore.create((IProject)ivyfile.getProject());
        ArrayList<IvyClasspathContainerImpl> containers = new ArrayList<IvyClasspathContainerImpl>();
        if (javaProject == null || !javaProject.exists()) {
            return containers;
        }
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IvyClasspathContainerImpl ivycp;
                IClasspathContainer cp;
                IPath path;
                IClasspathEntry entry = entries[i];
                if (entry != null && entry.getEntryKind() == 5 && IvyClasspathContainerHelper.isIvyClasspathContainer(path = entry.getPath()) && (cp = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)javaProject)) instanceof IvyClasspathContainerImpl && (ivycp = (IvyClasspathContainerImpl)cp).getConf().getIvyXmlPath().equals(ivyfile.getProjectRelativePath().toString())) {
                    containers.add(ivycp);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            IvyPlugin.log((CoreException)((Object)e));
        }
        return containers;
    }

    public static List getContainersFromIvySettings(IFile ivySettings) {
        IJavaProject javaProject = JavaCore.create((IProject)ivySettings.getProject());
        ArrayList<IvyClasspathContainerImpl> containers = new ArrayList<IvyClasspathContainerImpl>();
        if (javaProject == null || !javaProject.exists()) {
            return containers;
        }
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                block8: {
                    IClasspathContainer cp;
                    IPath path;
                    IClasspathEntry entry = entries[i];
                    if (entry != null && entry.getEntryKind() == 5 && IvyClasspathContainerHelper.isIvyClasspathContainer(path = entry.getPath()) && (cp = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)javaProject)) instanceof IvyClasspathContainerImpl) {
                        ResolvedPath settingsPath;
                        IvyClasspathContainerImpl ivycp = (IvyClasspathContainerImpl)cp;
                        try {
                            settingsPath = ivycp.getConf().getInheritedSettingsSetup().getResolvedIvySettingsPath(ivycp.getConf().getProject());
                        }
                        catch (IvyDEException ivyDEException) {
                            break block8;
                        }
                        if (settingsPath.getResolvedPath().equals(ivySettings.getProjectRelativePath().toString())) {
                            containers.add(ivycp);
                        }
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            IvyPlugin.log((CoreException)((Object)e));
        }
        return containers;
    }

    public static IvyClasspathContainer getContainer(IPath containerPath, IJavaProject javaProject) {
        IClasspathContainer cp;
        try {
            cp = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)javaProject);
        }
        catch (JavaModelException e) {
            IvyPlugin.log((CoreException)((Object)e));
            return null;
        }
        if (!(cp instanceof IvyClasspathContainerImpl)) {
            IvyPlugin.logError("Expected an Ivy container but was " + cp.getClass().getName() + " for path " + containerPath);
            return null;
        }
        return (IvyClasspathContainerImpl)cp;
    }

    public static IClasspathEntry getEntry(IPath containerPath, IJavaProject javaProject) {
        if (javaProject == null || !javaProject.exists()) {
            return null;
        }
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (entry != null && entry.getEntryKind() == 5 && containerPath.equals((Object)entry.getPath())) {
                    return entry;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            IvyPlugin.log((CoreException)((Object)e));
        }
        return null;
    }

    public static List getContainers(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null && javaProject.exists()) {
            return IvyClasspathContainerHelper.getContainers(javaProject);
        }
        return Collections.EMPTY_LIST;
    }

    public static IProject[] getIvyProjectsInWorkspace() {
        HashSet<IProject> ivyProjects = new HashSet<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isOpen() && IvyClasspathContainerHelper.getContainers(projects[i]).size() > 0) {
                ivyProjects.add(projects[i]);
            }
            ++i;
        }
        return ivyProjects.toArray(new IProject[ivyProjects.size()]);
    }
}

