/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.revdepexplorer;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;

public class MultiRevDependencyDescriptor {
    private final ModuleId moduleId;
    private final Map dependenciesByContainer = new HashMap();
    private String newRevision;

    public MultiRevDependencyDescriptor(ModuleId moduleId) {
        this.moduleId = moduleId;
    }

    public int hashCode() {
        return this.getOrganization().hashCode() + this.getModule().hashCode() + this.dependenciesByContainer.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof MultiRevDependencyDescriptor) {
            MultiRevDependencyDescriptor mrdd = (MultiRevDependencyDescriptor)o;
            if (this.getOrganization().equals(mrdd.getOrganization()) && this.getModule().equals(mrdd.getModule()) && this.dependenciesByContainer.equals(mrdd.dependenciesByContainer)) {
                return true;
            }
        }
        return false;
    }

    public boolean hasMultipleRevisons() {
        return this.getRevisions().length > 1;
    }

    public void addDependencyDescriptor(IvyClasspathContainerImpl container, DependencyDescriptor dependencyDescriptor) {
        HashSet<DependencyDescriptor> dependencies = (HashSet<DependencyDescriptor>)this.dependenciesByContainer.get(container);
        if (dependencies == null) {
            dependencies = new HashSet<DependencyDescriptor>();
            this.dependenciesByContainer.put(container, dependencies);
        }
        dependencies.add(dependencyDescriptor);
    }

    public String getModule() {
        return this.moduleId.getName();
    }

    public String getOrganization() {
        return this.moduleId.getOrganisation();
    }

    public String[] getRevisions() {
        HashSet<String> revisions = new HashSet<String>();
        Collection projectDependencyDescriptors = this.dependenciesByContainer.values();
        Iterator it = projectDependencyDescriptors.iterator();
        while (it.hasNext()) {
            Collection projectCollection = (Collection)it.next();
            Iterator descriptorIter = projectCollection.iterator();
            while (descriptorIter.hasNext()) {
                DependencyDescriptor descriptor = (DependencyDescriptor)descriptorIter.next();
                revisions.add(descriptor.getDependencyRevisionId().getRevision());
            }
        }
        return revisions.toArray(new String[revisions.size()]);
    }

    public boolean hasNewRevision() {
        return this.newRevision != null && !"".equals(this.newRevision.trim());
    }

    public void setNewRevision(String newRevision) {
        this.newRevision = newRevision;
    }

    public String getNewRevision() {
        return this.newRevision;
    }

    public IvyClasspathContainerImpl[] getIvyClasspathContainers() {
        Set containers = this.dependenciesByContainer.keySet();
        return containers.toArray(new IvyClasspathContainerImpl[containers.size()]);
    }

    public boolean isForContainer(IvyClasspathContainerImpl container) {
        IvyClasspathContainerImpl[] containers = this.getIvyClasspathContainers();
        int i = 0;
        while (i < containers.length) {
            IvyClasspathContainerImpl currentContainer = containers[i];
            if (currentContainer.equals(container)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ModuleId getModuleId() {
        return this.moduleId;
    }

    public String[] getRevisions(IvyClasspathContainerImpl container) {
        Collection containerDependencyDescriptors = (Collection)this.dependenciesByContainer.get(container);
        if (containerDependencyDescriptors == null) {
            return new String[0];
        }
        HashSet<String> revisions = new HashSet<String>();
        Iterator iter = containerDependencyDescriptors.iterator();
        while (iter.hasNext()) {
            DependencyDescriptor descriptor = (DependencyDescriptor)iter.next();
            revisions.add(descriptor.getDependencyRevisionId().getRevision());
        }
        return revisions.toArray(new String[revisions.size()]);
    }
}

