/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.console;

import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.ui.console.IvyConsole;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class IvyConsoleFilterAction
extends Action
implements IMenuCreator {
    private static final String[] LOG_LEVEL_MESSAGES = new String[]{"error", "warning", "info", "verbose", "debug"};
    private Menu fMenu;
    private IvyConsole console;

    public IvyConsoleFilterAction(IvyConsole console) {
        this.console = console;
        this.setText("Log filter");
        this.setToolTipText("Filter the log level of the Ivy console");
        this.setImageDescriptor(IvyPlugin.getImageDescriptor("/icons/log_level.png"));
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        Action action;
        int logLevel;
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        int i = 0;
        while (i < LOG_LEVEL_MESSAGES.length) {
            logLevel = i;
            action = new Action(LOG_LEVEL_MESSAGES[i]){

                public void run() {
                    IvyConsoleFilterAction.this.console.setLogLevel(logLevel);
                }
            };
            action.setChecked(this.console.getLogLevel() == i);
            this.addActionToMenu(this.fMenu, action);
            ++i;
        }
        new Separator().fill(this.fMenu, -1);
        i = 0;
        while (i < LOG_LEVEL_MESSAGES.length) {
            logLevel = i;
            action = new Action("IvyDE " + LOG_LEVEL_MESSAGES[i]){

                public void run() {
                    IvyConsoleFilterAction.this.console.getIvyDEMessageLogger().setLogLevel(logLevel);
                }
            };
            action.setChecked(this.console.getIvyDEMessageLogger().getLogLevel() == i);
            this.addActionToMenu(this.fMenu, action);
            ++i;
        }
        return this.fMenu;
    }

    private void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
    }
}

