/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.dialog;

import java.util.HashSet;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public abstract class ProjectSelectionDialog
extends SelectionStatusDialog {
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private ViewerFilter fFilter;
    private TableViewer fTableViewer;

    public ProjectSelectionDialog(Shell parentShell, ViewerFilter filter) {
        super(parentShell);
        this.fFilter = filter;
    }

    protected abstract boolean checkProject(IJavaProject var1);

    protected void computeResult() {
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Font font = parent.getFont();
        composite.setFont(font);
        this.createMessageArea(composite);
        this.fTableViewer = new TableViewer(composite, 2818);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectSelectionDialog.this.doSelectionChanged(((IStructuredSelection)event.getSelection()).toArray());
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectSelectionDialog.this.okPressed();
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 250;
        data.widthHint = 300;
        this.fTableViewer.getTable().setLayoutData((Object)data);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider());
        this.fTableViewer.setContentProvider(this.getContentProvider());
        this.fTableViewer.setComparator((ViewerComparator)new JavaElementComparator());
        this.fTableViewer.getControl().setFont(font);
        this.updateFilter(true);
        IJavaModel input = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.fTableViewer.setInput((Object)input);
        this.doSelectionChanged(new Object[0]);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doSelectionChanged(Object[] objects) {
        this.updateStatus((IStatus)new Status(0, "com.liferay.ide.ui", ""));
        this.setSelectionResult(objects);
    }

    protected IContentProvider getContentProvider() {
        return new JavaProjectProvider();
    }

    protected void updateFilter(boolean selected) {
        if (this.fFilter == null) {
            return;
        }
        if (selected) {
            this.fTableViewer.addFilter(this.fFilter);
        } else {
            this.fTableViewer.removeFilter(this.fFilter);
        }
    }

    class JavaProjectProvider
    extends StandardJavaElementContentProvider {
        JavaProjectProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IJavaModel) {
                IJavaModel model = (IJavaModel)element;
                HashSet<IJavaProject> set = new HashSet<IJavaProject>();
                try {
                    IJavaProject[] projects = model.getJavaProjects();
                    int i = 0;
                    while (i < projects.length) {
                        if (ProjectSelectionDialog.this.checkProject(projects[i])) {
                            set.add(projects[i]);
                        }
                        ++i;
                    }
                }
                catch (JavaModelException javaModelException) {}
                return set.toArray();
            }
            return super.getChildren(element);
        }
    }
}

