/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.migration;

import com.liferay.blade.api.Problem;
import com.liferay.ide.project.ui.migration.MigrationUtil;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class MigrationDecorator
extends BaseLabelProvider
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        ArrayList<Problem> resolvedProblems = new ArrayList<Problem>();
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            problems.addAll(MigrationUtil.getProblemsFromResource(resource));
            resolvedProblems.addAll(MigrationUtil.getResolvedProblemsFromResource(resource));
        }
        if (problems != null && problems.size() > 0) {
            for (Problem problem : problems) {
                if (problem.getStatus() != 1 || resolvedProblems.contains(problem)) continue;
                resolvedProblems.add(problem);
            }
            StringBuilder sb = new StringBuilder();
            if (resolvedProblems.size() > 0) {
                sb.append(", " + resolvedProblems.size() + " resolved");
            }
            sb.append("]");
            decoration.addSuffix(sb.toString());
        }
    }
}

