/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade;

import com.liferay.ide.project.core.upgrade.Liferay7UpgradeAssistantSettings;
import com.liferay.ide.project.core.upgrade.PortalSettings;
import com.liferay.ide.project.core.upgrade.UpgradeAssistantSettingsUtil;
import com.liferay.ide.project.ui.upgrade.GetPortalSettingsOp;
import com.liferay.ide.project.ui.upgrade.GetPortalSettingsWizard;
import com.liferay.ide.ui.util.UIUtil;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.ServerDelegate;

public class SetupPortalServerHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String newName = null;
        String newLocation = null;
        Liferay7UpgradeAssistantSettings settings = null;
        try {
            settings = (Liferay7UpgradeAssistantSettings)UpgradeAssistantSettingsUtil.getObjectFromStore(Liferay7UpgradeAssistantSettings.class);
            if (settings == null) {
                settings = new Liferay7UpgradeAssistantSettings();
            } else {
                PortalSettings portalSettings = settings.getPortalSettings();
                newName = portalSettings.getNewName();
                newLocation = portalSettings.getNewLiferayPortalLocation();
            }
        }
        catch (IOException iOException) {}
        if (newLocation == null) {
            GetPortalSettingsWizard wizard = new GetPortalSettingsWizard();
            int retcode = new WizardDialog(UIUtil.getActiveShell(), (IWizard)wizard).open();
            if (retcode == 0) {
                newName = (String)((GetPortalSettingsOp)wizard.element()).getNewLiferayName().content();
                newLocation = ((org.eclipse.sapphire.modeling.Path)((GetPortalSettingsOp)wizard.element()).getNewLiferayLocation().content()).toOSString();
                PortalSettings portalSettings = settings.getPortalSettings();
                if (portalSettings == null) {
                    portalSettings = new PortalSettings();
                }
                portalSettings.setNewName(newName);
                portalSettings.setNewLiferayPortalLocation(newLocation);
                settings.setPortalSettings(portalSettings);
            }
        }
        if (newName != null && newLocation != null) {
            try {
                NullProgressMonitor npm = new NullProgressMonitor();
                IRuntimeWorkingCopy portalRuntimeWC = ServerCore.findRuntimeType((String)"com.liferay.ide.server.portal.runtime").createRuntime(newName, (IProgressMonitor)npm);
                portalRuntimeWC.setLocation((IPath)new Path(newLocation));
                portalRuntimeWC.setName(newName);
                IRuntime portalRuntime = portalRuntimeWC.save(true, (IProgressMonitor)npm);
                IServerWorkingCopy serverWC = ServerCore.findServerType((String)"com.liferay.ide.server.portal").createServer(newName, null, portalRuntime, (IProgressMonitor)npm);
                ServerDelegate delegate = (ServerDelegate)serverWC.loadAdapter(ServerDelegate.class, null);
                delegate.importRuntimeConfiguration(serverWC.getRuntime(), null);
                IServer server = serverWC.save(true, (IProgressMonitor)npm);
                if (server != null) {
                    UpgradeAssistantSettingsUtil.setObjectToStore(Liferay7UpgradeAssistantSettings.class, (Object)settings);
                }
                MessageDialog.openInformation((Shell)UIUtil.getActiveShell(), (String)"Setup Portal Server", (String)"Liferay 7 server setup complete.");
            }
            catch (IOException | CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

