/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.wizard;

import com.liferay.ide.project.core.facet.IPluginProjectDataModelProperties;
import com.liferay.ide.ui.util.SWTUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelSynchHelper;
import org.eclipse.wst.common.frameworks.internal.ui.NewProjectGroup;

public class NewPluginProjectGroup
extends NewProjectGroup
implements IPluginProjectDataModelProperties {
    protected static final int SIZING_TEXT_FIELD_WIDTH = 305;
    protected Button customLocationButton;
    protected Text displayNameField;
    protected IDataModel model;
    protected IDataModel nestedModel;
    protected DataModelSynchHelper nestedSynchHelper;
    protected Button sdkLocationButton;
    protected DataModelSynchHelper synchHelper;
    protected Button workspaceLocationButton;

    public NewPluginProjectGroup(Composite parent, IDataModel model, IDataModel nestedModel) {
        super(parent, model);
        this.model = model;
        this.nestedModel = nestedModel;
        this.synchHelper = new DataModelSynchHelper(model);
        this.nestedSynchHelper = new DataModelSynchHelper(nestedModel);
        this.createControl(parent);
    }

    public void buildComposites(Composite parent) {
    }

    public void createControl(Composite parent) {
        this.createProjectNameGroup(parent);
        this.createDisplayNameGroup(parent);
    }

    public void dispose() {
        this.model.removeListener((IDataModelListener)this.synchHelper);
        this.synchHelper.dispose();
        this.model = null;
    }

    protected void createDisplayNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite displayGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        displayGroup.setLayout((Layout)layout);
        displayGroup.setLayoutData((Object)new GridData(768));
        Label displayLabel = new Label(displayGroup, 0);
        displayLabel.setFont(font);
        displayLabel.setText(Msgs.displayNameLabel);
        this.displayNameField = new Text(displayGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 305;
        this.displayNameField.setLayoutData((Object)data);
        this.displayNameField.setFont(font);
        this.synchHelper.synchText(this.displayNameField, "IPluginProjectCreationPropertiesNew.DISPLAY_NAME", new Control[]{displayLabel});
        this.nestedSynchHelper.getDataModel().addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if ("IProjectCreationPropertiesNew.PROJECT_NAME".equals(event.getPropertyName())) {
                    NewPluginProjectGroup.this.synchHelper.synchAllUIWithModel();
                }
            }
        });
    }

    protected void createProjectLocationGroup(Composite parent) {
        Group projectLocationGroup = new Group(parent, 0);
        projectLocationGroup.setText(Msgs.location);
        projectLocationGroup.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        projectLocationGroup.setLayoutData((Object)gd);
        this.sdkLocationButton = SWTUtil.createRadioButton((Composite)projectLocationGroup, (String)Msgs.createNewProjectSDK, null, (boolean)true, (int)3);
        this.synchHelper.synchRadio(this.sdkLocationButton, "IPluginProjectDataModelProperties.LIFERAY_USE_SDK_LOCATION", null);
        this.workspaceLocationButton = SWTUtil.createRadioButton((Composite)projectLocationGroup, (String)Msgs.createNewProjectWorkspace, null, (boolean)true, (int)3);
        this.nestedSynchHelper.synchRadio(this.workspaceLocationButton, "IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION", null);
        this.customLocationButton = SWTUtil.createRadioButton((Composite)projectLocationGroup, (String)Msgs.createNewProjectLabel, null, (boolean)true, (int)3);
        this.synchHelper.synchRadio(this.customLocationButton, "IPluginProjectDataModelProperties.LIFERAY_USE_CUSTOM_LOCATION", null);
        this.createUserSpecifiedProjectLocationField((Composite)projectLocationGroup);
    }

    protected void createProjectNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setFont(font);
        projectLabel.setText(Msgs.projectNameLabel);
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 305;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(font);
        this.nestedSynchHelper.synchText(this.projectNameField, "IProjectCreationPropertiesNew.PROJECT_NAME", new Control[]{projectLabel});
    }

    protected void createUserSpecifiedProjectLocationField(Composite projectGroup) {
        Font font = projectGroup.getFont();
        Label locationLabel = new Label(projectGroup, 0);
        locationLabel.setFont(font);
        locationLabel.setText(Msgs.WizardNewProjectCreationPage_locationLabel);
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 305;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setFont(font);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setFont(font);
        this.browseButton.setText(Msgs.browse);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewPluginProjectGroup.this.handleLocationBrowseButtonPressed();
            }
        });
        IDataModel localModel = this.model;
        IDataModel localNestedModel = this.nestedModel;
        class LocationListener
        implements ModifyListener,
        IDataModelListener {
            private boolean propertySet = false;
            private boolean typing = false;
            private final /* synthetic */ IDataModel val$localModel;
            private final /* synthetic */ IDataModel val$localNestedModel;
            private final /* synthetic */ Label val$locationLabel;

            LocationListener(IDataModel iDataModel, IDataModel iDataModel2, Label label) {
                this.val$localModel = iDataModel;
                this.val$localNestedModel = iDataModel2;
                this.val$locationLabel = label;
            }

            public void modifyText(ModifyEvent e) {
                if (!(this.val$localModel.getBooleanProperty("IPluginProjectDataModelProperties.LIFERAY_USE_SDK_LOCATION") || this.val$localNestedModel.getBooleanProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION") || this.propertySet)) {
                    try {
                        this.typing = true;
                        this.val$localNestedModel.setProperty("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION", (Object)NewPluginProjectGroup.this.locationPathField.getText());
                    }
                    finally {
                        this.typing = false;
                    }
                }
            }

            public void propertyChanged(DataModelEvent event) {
                boolean useDefault = this.val$localNestedModel.getBooleanProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION");
                if ("IPluginProjectDataModelProperties.LIFERAY_USE_SDK_LOCATION".equals(event.getPropertyName()) || "IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION".equals(event.getPropertyName()) || "IPluginProjectDataModelProperties.LIFERAY_USE_CUSTOM_LOCATION".equals(event.getPropertyName()) || "IPluginProjectDataModelProperties.LIFERAY_SDK_NAME".equals(event.getPropertyName())) {
                    boolean enableLocationField = this.val$localModel.getBooleanProperty("IPluginProjectDataModelProperties.LIFERAY_USE_CUSTOM_LOCATION");
                    this.val$locationLabel.setEnabled(enableLocationField);
                    NewPluginProjectGroup.this.locationPathField.setEnabled(enableLocationField);
                    NewPluginProjectGroup.this.browseButton.setEnabled(enableLocationField);
                    this.propertySet = true;
                    if (useDefault) {
                        NewPluginProjectGroup.this.locationPathField.setText(this.val$localNestedModel.getStringProperty("IProjectCreationPropertiesNew.DEFAULT_LOCATION"));
                    } else if (this.val$localModel.getBooleanProperty("IPluginProjectDataModelProperties.LIFERAY_USE_SDK_LOCATION")) {
                        NewPluginProjectGroup.this.locationPathField.setText(this.val$localNestedModel.getStringProperty("IProjectCreationPropertiesNew.PROJECT_LOCATION"));
                    } else if (this.val$localModel.getBooleanProperty("IPluginProjectDataModelProperties.LIFERAY_USE_CUSTOM_LOCATION")) {
                        NewPluginProjectGroup.this.locationPathField.setText(this.val$localNestedModel.getStringProperty("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION"));
                    }
                    this.propertySet = false;
                } else if (!this.typing && (useDefault && "IProjectCreationPropertiesNew.DEFAULT_LOCATION".equals(event.getPropertyName()) || !useDefault && ("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION".equals(event.getPropertyName()) || "IProjectCreationPropertiesNew.PROJECT_LOCATION".equals(event.getPropertyName())))) {
                    this.propertySet = true;
                    NewPluginProjectGroup.this.locationPathField.setText((String)event.getProperty());
                    this.propertySet = false;
                }
            }
        }
        LocationListener listener = new LocationListener(localModel, localNestedModel, locationLabel);
        listener.propertyChanged(new DataModelEvent(this.model, "IPluginProjectDataModelProperties.LIFERAY_USE_SDK_LOCATION", 1));
        this.locationPathField.addModifyListener((ModifyListener)listener);
        this.model.addListener((IDataModelListener)listener);
        this.nestedModel.addListener((IDataModelListener)listener);
    }

    private static class Msgs
    extends NLS {
        public static String browse;
        public static String createNewProjectLabel;
        public static String createNewProjectSDK;
        public static String createNewProjectWorkspace;
        public static String displayNameLabel;
        public static String location;
        public static String projectNameLabel;
        public static String WizardNewProjectCreationPage_locationLabel;

        static {
            Msgs.initializeMessages((String)NewPluginProjectGroup.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

