/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core;

import com.liferay.ide.core.util.CoreUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.PropertiesConfigurationLayout;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class PluginPropertiesConfigurationLayout
extends PropertiesConfigurationLayout {
    public static final String[] sortedKeys = new String[]{"name", "module-group-id", "module-incremental-version", "tags", "short-description", "long-description", "change-log", "page-url", "author", "licenses", "liferay-versions", "portal-dependency-jars", "deploy-excludes", "portal-dependency-tlds", "speed-filters-enabled"};

    public PluginPropertiesConfigurationLayout(PropertiesConfiguration config) {
        super(config);
        this.setForceSingleLine(true);
        this.setSingleLine("portal-dependency-jars", false);
        this.setSingleLine("portal-dependency-tlds", false);
        this.setSingleLine("deploy-excludes", false);
        this.setSingleLine("required-deployment-contexts", false);
    }

    public boolean isWrappedProperty(String key) {
        return key.equals("portal-dependency-jars") || key.equals("portal-dependency-tlds") || key.equals("deploy-excludes") || key.equals("required-deployment-contexts");
    }

    public void save(Writer out) throws ConfigurationException {
        try {
            char delimiter = this.getConfiguration().isDelimiterParsingDisabled() ? (char)'\u0000' : this.getConfiguration().getListDelimiter();
            PluginPropertiesWriter writer = new PluginPropertiesWriter(out, delimiter);
            if (this.getHeaderComment() != null) {
                writer.writeln(this.getCanonicalHeaderComment(true));
                writer.writeln(null);
            }
            List<Object> keyList = Arrays.asList(this.getKeys().toArray());
            Collections.sort(keyList, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    int index1 = Integer.MAX_VALUE;
                    int index2 = Integer.MAX_VALUE;
                    int i = 0;
                    while (i < sortedKeys.length) {
                        if (sortedKeys[i].equals(o1)) {
                            index1 = i;
                        }
                        if (sortedKeys[i].equals(o2)) {
                            index2 = i;
                        }
                        ++i;
                    }
                    if (index1 < index2) {
                        return -1;
                    }
                    if (index1 > index2) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (String string : keyList) {
                if (!this.getConfiguration().containsKey(string)) continue;
                int i = 0;
                while (i < this.getBlancLinesBefore(string)) {
                    writer.writeln(null);
                    ++i;
                }
                if (this.getComment(string) != null) {
                    writer.writeln(this.getCanonicalComment(string, true));
                }
                boolean singleLine = (this.isForceSingleLine() || this.isSingleLine(string)) && !this.getConfiguration().isDelimiterParsingDisabled();
                boolean wrappedProperty = this.isWrappedProperty(string);
                writer.writeProperty(string, this.getConfiguration().getProperty(string), singleLine, wrappedProperty);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException ioex) {
            throw new ConfigurationException((Throwable)ioex);
        }
    }

    public static class PluginPropertiesWriter
    extends PropertiesConfiguration.PropertiesWriter {
        private static final String ESCAPE = "\\";
        private static final char[] SEPARATORS = new char[]{'=', ':'};
        private static final char[] WHITE_SPACE = new char[]{' ', '\t', '\f'};
        private char delimiter;

        public PluginPropertiesWriter(Writer writer, char delimiter) {
            super(writer, delimiter);
            this.delimiter = delimiter;
        }

        /*
         * Unable to fully structure code
         */
        public void writeProperty(String key, Object value, boolean forceSingleLine, boolean wrappedProperty) throws IOException {
            if (!(value instanceof List)) ** GOTO lbl8
            values = (List)value;
            if (forceSingleLine) {
                v = this.makeSingleLineValue(values);
            } else {
                this.writeProperty(key, values);
                return;
lbl8:
                // 1 sources

                if (wrappedProperty) {
                    values = value.toString().split(",");
                    buf = new StringBuffer();
                    var11_9 = values;
                    var10_10 = values.length;
                    var9_11 = 0;
                    while (var9_11 < var10_10) {
                        val = var11_9[var9_11];
                        if (key.equals("deploy-excludes") && !val.startsWith("**/WEB-INF/lib/")) {
                            val = "**/WEB-INF/lib/" + val;
                        }
                        if (CoreUtil.isNullOrEmpty((String)buf.toString())) {
                            buf.append("\\\n");
                            buf.append("    " + this.escapeValue(val));
                        } else {
                            buf.append(",\\\n    " + this.escapeValue(val));
                        }
                        ++var9_11;
                    }
                    v = buf.toString();
                } else {
                    v = this.escapeValue(value);
                }
            }
            this.write(this.escapeKey(key));
            this.write("=");
            this.write(v);
            this.writeln(null);
        }

        private String escapeKey(String key) {
            StringBuffer newkey = new StringBuffer();
            int i = 0;
            while (i < key.length()) {
                char c = key.charAt(i);
                if (ArrayUtils.contains((char[])SEPARATORS, (char)c) || ArrayUtils.contains((char[])WHITE_SPACE, (char)c)) {
                    newkey.append('\\');
                    newkey.append(c);
                } else {
                    newkey.append(c);
                }
                ++i;
            }
            return newkey.toString();
        }

        private String escapeValue(Object value) {
            String escapedValue = StringEscapeUtils.escapeJava((String)String.valueOf(value));
            if (this.delimiter != '\u0000') {
                escapedValue = StringUtils.replace((String)escapedValue, (String)String.valueOf(this.delimiter), (String)(ESCAPE + this.delimiter));
            }
            return escapedValue;
        }

        private String makeSingleLineValue(List values) {
            if (!values.isEmpty()) {
                Iterator it = values.iterator();
                String lastValue = this.escapeValue(it.next());
                StringBuffer buf = new StringBuffer(lastValue);
                while (it.hasNext()) {
                    if (lastValue.endsWith(ESCAPE)) {
                        buf.append(ESCAPE).append(ESCAPE);
                    }
                    buf.append(this.delimiter);
                    lastValue = this.escapeValue(it.next());
                    buf.append(lastValue);
                }
                return buf.toString();
            }
            return null;
        }
    }
}

