/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.dd;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.portlet.core.operation.INewPortletClassDataModelProperties;
import com.liferay.ide.project.core.descriptor.AddNewPortletOperation;
import com.liferay.ide.project.core.descriptor.IDescriptorOperation;
import com.liferay.ide.project.core.descriptor.LiferayDescriptorHelper;
import com.liferay.ide.project.core.descriptor.RemoveAllPortletsOperation;
import com.liferay.ide.project.core.descriptor.RemoveSampleElementsOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LiferayPortletDescriptorHelper
extends LiferayDescriptorHelper
implements INewPortletClassDataModelProperties {
    public static final String DESCRIPTOR_FILE = "liferay-portlet.xml";
    private static final String DESCRIPTOR_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE liferay-portlet-app PUBLIC \"-//Liferay//DTD Portlet Application {0}//EN\" \"http://www.liferay.com/dtd/liferay-portlet-app_{1}.dtd\">\n\n<liferay-portlet-app>\n\t<role-mapper>\n\t\t<role-name>administrator</role-name>\n\t\t<role-link>Administrator</role-link>\n\t</role-mapper>\n\t<role-mapper>\n\t\t<role-name>guest</role-name>\n\t\t<role-link>Guest</role-link>\n\t</role-mapper>\n\t<role-mapper>\n\t\t<role-name>power-user</role-name>\n\t\t<role-link>Power User</role-link>\n\t</role-mapper>\n\t<role-mapper>\n\t\t<role-name>user</role-name>\n\t\t<role-link>User</role-link>\n\t</role-mapper>\n</liferay-portlet-app>";

    public LiferayPortletDescriptorHelper() {
    }

    public LiferayPortletDescriptorHelper(IProject project) {
        super(project);
    }

    protected void addDescriptorOperations() {
        this.addDescriptorOperation((IDescriptorOperation)new AddNewPortletOperation(){

            public IStatus addNewPortlet(final IDataModel model) {
                IFile descriptorFile;
                IStatus status = Status.OK_STATUS;
                if (LiferayPortletDescriptorHelper.this.canAddNewPortlet(model) && (descriptorFile = LiferayPortletDescriptorHelper.this.getDescriptorFile()) != null) {
                    LiferayDescriptorHelper.DOMModelEditOperation domModelOperation = new LiferayDescriptorHelper.DOMModelEditOperation(LiferayPortletDescriptorHelper.this, descriptorFile){

                        protected void createDefaultFile() {
                            this.createDefaultDescriptor(LiferayPortletDescriptorHelper.DESCRIPTOR_TEMPLATE, LiferayPortletDescriptorHelper.this.getDescriptorVersion());
                        }

                        protected IStatus doExecute(IDOMDocument document) {
                            return LiferayPortletDescriptorHelper.this.doAddNewPortlet(document, model);
                        }
                    };
                    status = domModelOperation.execute();
                }
                return status;
            }
        });
        this.addDescriptorOperation((IDescriptorOperation)new RemoveAllPortletsOperation(){

            public IStatus removeAllPortlets() {
                return LiferayPortletDescriptorHelper.this.doRemoveAllPortlets();
            }
        });
        this.addDescriptorOperation((IDescriptorOperation)new RemoveSampleElementsOperation(){

            public IStatus removeSampleElements() {
                return LiferayPortletDescriptorHelper.this.doRemoveAllPortlets();
            }
        });
    }

    protected boolean canAddNewPortlet(IDataModel model) {
        return model.getID().contains("NewPortlet");
    }

    public IStatus configureLiferayPortletXml(final String newPortletName) {
        IStatus status = Status.OK_STATUS;
        IFile descriptorFile = this.getDescriptorFile();
        if (descriptorFile != null) {
            LiferayDescriptorHelper.DOMModelEditOperation operation = new LiferayDescriptorHelper.DOMModelEditOperation(this, descriptorFile){

                protected IStatus doExecute(IDOMDocument document) {
                    Element rootElement = document.getDocumentElement();
                    NodeList portletNodes = rootElement.getElementsByTagName("portlet");
                    if (portletNodes.getLength() > 0) {
                        Element lastPortletElement = (Element)portletNodes.item(portletNodes.getLength() - 1);
                        Element portletName = NodeUtil.findChildElement((Element)lastPortletElement, (String)"portlet-name");
                        portletName.replaceChild(document.createTextNode(newPortletName), portletName.getFirstChild());
                    }
                    return Status.OK_STATUS;
                }
            };
            status = operation.execute();
        }
        return status;
    }

    protected IStatus doAddNewPortlet(IDOMDocument document, IDataModel model) {
        Element rootElement = document.getDocumentElement();
        Element newPortletElement = document.createElement("portlet");
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"portlet-name", (String)model.getStringProperty("INewPortletClassDataModelProperties.LIFERAY_PORTLET_NAME"));
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"icon", (String)model.getStringProperty("INewPortletClassDataModelProperties.ICON_FILE"));
        if (model.getBooleanProperty("INewPortletClassDataModelProperties.ADD_TO_CONTROL_PANEL")) {
            String entryCategory = model.getStringProperty("INewPortletClassDataModelProperties.ENTRY_CATEGORY").replaceAll("^category\\.", "");
            NodeUtil.appendChildElement((Element)newPortletElement, (String)"control-panel-entry-category", (String)entryCategory);
            NodeUtil.appendChildElement((Element)newPortletElement, (String)"control-panel-entry-weight", (String)model.getStringProperty("INewPortletClassDataModelProperties.ENTRY_WEIGHT"));
            String javaPackage = model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
            if (!CoreUtil.isNullOrEmpty((String)javaPackage)) {
                javaPackage = String.valueOf(javaPackage) + ".";
            }
            if (model.getBooleanProperty("INewPortletClassDataModelProperties.CREATE_ENTRY_CLASS")) {
                NodeUtil.appendChildElement((Element)newPortletElement, (String)"control-panel-entry-class", (String)(String.valueOf(javaPackage) + model.getStringProperty("INewPortletClassDataModelProperties.ENTRY_CLASS_NAME")));
            }
        }
        if (model.getBooleanProperty("INewPortletClassDataModelProperties.ALLOW_MULTIPLE")) {
            NodeUtil.appendChildElement((Element)newPortletElement, (String)"instanceable", (String)Boolean.toString(model.getBooleanProperty("INewPortletClassDataModelProperties.ALLOW_MULTIPLE")));
        }
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"header-portlet-css", (String)model.getStringProperty("INewPortletClassDataModelProperties.CSS_FILE"));
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"footer-portlet-javascript", (String)model.getStringProperty("INewPortletClassDataModelProperties.JAVASCRIPT_FILE"));
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"css-class-wrapper", (String)model.getStringProperty("INewPortletClassDataModelProperties.CSS_CLASS_WRAPPER"));
        Element firstRoleMapper = null;
        for (Element child : this.getChildElements(rootElement)) {
            if (!child.getNodeName().equals("role-mapper")) continue;
            firstRoleMapper = child;
            break;
        }
        Text newline = document.createTextNode(System.getProperty("line.separator"));
        if (firstRoleMapper != null) {
            rootElement.insertBefore(newPortletElement, firstRoleMapper);
            rootElement.insertBefore(newline, firstRoleMapper);
        } else {
            rootElement.appendChild(newPortletElement);
            rootElement.appendChild(newline);
        }
        FormatProcessorXML processor = new FormatProcessorXML();
        processor.formatNode((Node)newPortletElement);
        return Status.OK_STATUS;
    }

    protected IStatus doRemoveAllPortlets() {
        LiferayDescriptorHelper.DOMModelEditOperation domModelOperation = new LiferayDescriptorHelper.DOMModelEditOperation(this, this.getDescriptorFile()){

            protected IStatus doExecute(IDOMDocument document) {
                return LiferayPortletDescriptorHelper.this.removeAllElements(document, "portlet");
            }
        };
        IStatus status = domModelOperation.execute();
        return status;
    }

    public IFile getDescriptorFile() {
        return super.getDescriptorFile(DESCRIPTOR_FILE);
    }
}

