/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.lfportlet.model.internal;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.portlet.core.lfportlet.model.PortletStyleElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class PortletStyleValidationService
extends ValidationService {
    protected Status compute() {
        Element modelElement = (Element)this.context(Element.class);
        if (!modelElement.disposed() && modelElement instanceof PortletStyleElement) {
            Path path = (Path)modelElement.property((ValueProperty)this.context(ValueProperty.class)).content();
            if (path != null) {
                String name = path.lastSegment();
                IProject project = (IProject)modelElement.adapt(IProject.class);
                boolean fileExisted = new FileCheckVisitor().checkFiles((IResource)project, name);
                if (!fileExisted) {
                    return Status.createErrorStatus((String)("File " + path.toPortableString() + " is not existed"));
                }
            } else {
                return Status.createErrorStatus((String)"Can not set empty value");
            }
        }
        return Status.createOkStatus();
    }

    private static class FileCheckVisitor
    implements IResourceProxyVisitor {
        String searchFileName = null;
        boolean fileExisted = false;

        private FileCheckVisitor() {
        }

        public boolean visit(IResourceProxy resourceProxy) {
            IResource resource;
            if (resourceProxy.getType() == 1 && resourceProxy.getName().equals(this.searchFileName) && (resource = resourceProxy.requestResource()).exists()) {
                this.fileExisted = true;
            }
            return true;
        }

        public boolean checkFiles(IResource container, String searchFileName) {
            this.searchFileName = searchFileName;
            try {
                container.accept((IResourceProxyVisitor)this, 4);
            }
            catch (CoreException e) {
                LiferayCore.logError((Throwable)e);
            }
            return this.fileExisted;
        }
    }
}

