/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.model.internal;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.portlet.core.model.Portlet;
import com.liferay.ide.portlet.core.model.SupportedLocales;
import com.liferay.ide.portlet.core.util.PortletUtil;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class LocaleBundleValidationService
extends ValidationService {
    private FilteredListener<PropertyContentEvent> listener;

    protected void initValidationService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                if (!((SupportedLocales)LocaleBundleValidationService.this.context(SupportedLocales.class)).disposed()) {
                    LocaleBundleValidationService.this.refresh();
                }
            }
        };
        ((Portlet)((SupportedLocales)this.context(SupportedLocales.class)).nearest(Portlet.class)).getResourceBundle().attach(this.listener);
    }

    public void forceRefresh() {
        if (!((SupportedLocales)this.context(SupportedLocales.class)).disposed()) {
            this.refresh();
        }
    }

    public Status compute() {
        Element modelElement = (Element)this.context(Element.class);
        if (!modelElement.disposed() && modelElement instanceof SupportedLocales) {
            IProject project = (IProject)modelElement.adapt(IProject.class);
            Portlet portlet = (Portlet)modelElement.nearest(Portlet.class);
            IWorkspaceRoot wroot = ResourcesPlugin.getWorkspace().getRoot();
            IClasspathEntry[] cpEntries = CoreUtil.getClasspathEntries((IProject)project);
            if (cpEntries != null) {
                String locale = modelElement.property((ValueProperty)this.context(ValueProperty.class)).text(false);
                Value<Path> resourceBundle = portlet.getResourceBundle();
                if (locale == null) {
                    return Status.createErrorStatus((String)Resources.localeMustNotEmpty);
                }
                String bundleName = resourceBundle.text();
                if (resourceBundle != null && bundleName != null) {
                    String localeString = PortletUtil.localeString(locale);
                    String ioFileName = PortletUtil.convertJavaToIoFileName(bundleName, "properties", localeString);
                    IClasspathEntry[] iClasspathEntryArray = cpEntries;
                    int n = cpEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
                        if (3 == iClasspathEntry.getEntryKind()) {
                            IPath entryPath = wroot.getFolder(iClasspathEntry.getPath()).getLocation();
                            IFile resourceBundleFile = wroot.getFileForLocation(entryPath = entryPath.append(ioFileName));
                            if (resourceBundleFile != null && resourceBundleFile.exists()) {
                                return Status.createOkStatus();
                            }
                            return Status.createWarningStatus((String)Resources.bind((String)StringEscapeUtils.unescapeJava((String)Resources.noResourceBundle), (Object[])new Object[]{locale, bundleName, localeString}));
                        }
                        ++n2;
                    }
                }
            }
        }
        return Status.createOkStatus();
    }

    public void dispose() {
        try {
            ((Portlet)((SupportedLocales)this.context(SupportedLocales.class)).nearest(Portlet.class)).getResourceBundle().detach(this.listener);
        }
        catch (Exception exception) {}
    }

    private static final class Resources
    extends NLS {
        public static String localeMustNotEmpty;
        public static String noResourceBundle;

        static {
            Resources.initializeMessages((String)LocaleBundleValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

