/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.model.internal;

import com.liferay.ide.portlet.core.model.CustomPortletMode;
import com.liferay.ide.portlet.core.model.PortletMode;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ImageService;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;

public class PortletModeImageService
extends ImageService {
    private static final ImageData IMG_DEFAULT = (ImageData)ImageData.readFromClassLoader(PortletModeImageService.class, (String)"images/portlet.png").required();
    private static final ImageData IMG_VIEW = (ImageData)ImageData.readFromClassLoader(PortletModeImageService.class, (String)"images/view.png").required();
    private static final ImageData IMG_EDIT = (ImageData)ImageData.readFromClassLoader(PortletModeImageService.class, (String)"images/edit.png").required();
    private static final ImageData IMG_HELP = (ImageData)ImageData.readFromClassLoader(PortletModeImageService.class, (String)"images/help.png").required();
    private Listener listener;

    protected void initImageService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                PortletModeImageService.this.refresh();
            }
        };
        ((Element)this.context(Element.class)).attach(this.listener, PortletMode.PROP_PORTLET_MODE.name());
    }

    protected ImageData compute() {
        String portletMode = null;
        Element element = (Element)this.context(Element.class);
        ImageData imageData = null;
        if (element instanceof CustomPortletMode) {
            CustomPortletMode iCustomPortletMode = (CustomPortletMode)element;
            portletMode = String.valueOf(iCustomPortletMode.getPortletMode().content());
        } else if (element instanceof PortletMode) {
            PortletMode iPortletMode = (PortletMode)element;
            portletMode = (String)iPortletMode.getPortletMode().content();
        }
        if (portletMode != null) {
            if ("VIEW".equalsIgnoreCase(portletMode)) {
                imageData = IMG_VIEW;
            } else if ("EDIT".equalsIgnoreCase(portletMode)) {
                imageData = IMG_EDIT;
            } else if ("HELP".equalsIgnoreCase(portletMode)) {
                imageData = IMG_HELP;
            }
        }
        if (imageData == null) {
            imageData = IMG_DEFAULT;
        }
        return imageData;
    }

    public void dispose() {
        super.dispose();
        ((Element)this.context(Element.class)).detach(this.listener, PortletMode.PROP_PORTLET_MODE.name());
    }
}

