/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.collection;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.collection.Queue;
import org.eclipse.jpt.common.utility.collection.Stack;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.internal.collection.LinkedStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedStack<E>
implements Stack<E>,
Serializable {
    private final Stack<E> stack;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedStack(Stack<E> stack, Object mutex) {
        if (stack == null || mutex == null) {
            throw new NullPointerException();
        }
        this.stack = stack;
        this.mutex = mutex;
    }

    public SynchronizedStack(Stack<E> stack) {
        if (stack == null) {
            throw new NullPointerException();
        }
        this.stack = stack;
        this.mutex = this;
    }

    public SynchronizedStack(Object mutex) {
        this(new LinkedStack(), mutex);
    }

    public SynchronizedStack() {
        this(new LinkedStack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(E element) {
        Object object = this.mutex;
        synchronized (object) {
            this.push_(element);
        }
    }

    private void push_(E element) {
        this.stack.push(element);
        this.mutex.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pop() {
        Object object = this.mutex;
        synchronized (object) {
            return this.pop_();
        }
    }

    private E pop_() {
        E o = this.stack.pop();
        this.mutex.notifyAll();
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Object object = this.mutex;
        synchronized (object) {
            return this.stack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.stack.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEmptyIs(boolean empty) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(empty);
        }
    }

    private void waitUntilEmptyIs_(boolean empty) throws InterruptedException {
        while (this.stack.isEmpty() != empty) {
            this.mutex.wait();
        }
    }

    public void waitUntilEmpty() throws InterruptedException {
        this.waitUntilEmptyIs(true);
    }

    public void waitUntilNotEmpty() throws InterruptedException {
        this.waitUntilEmptyIs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToPush(E element) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(true);
            this.push_(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitToPop() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(false);
            return this.pop_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilEmptyIs(boolean empty, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilEmptyIs_(empty, timeout);
        }
    }

    private boolean waitUntilEmptyIs_(boolean empty, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntilEmptyIs_(empty);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (this.stack.isEmpty() != empty && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return this.stack.isEmpty() == empty;
    }

    public boolean waitUntilEmpty(long timeout) throws InterruptedException {
        return this.waitUntilEmptyIs(true, timeout);
    }

    public boolean waitUntilNotEmpty(long timeout) throws InterruptedException {
        return this.waitUntilEmptyIs(false, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToPush(E element, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilEmptyIs_(true, timeout);
            if (success) {
                this.push_(element);
            }
            return success;
        }
    }

    public Object waitToPop(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilEmptyIs_(false, timeout);
            if (success) {
                return this.pop_();
            }
            throw new EmptyStackException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    public void pushAll(Iterable<? extends E> iterable) {
        this.pushAll(iterable.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushAll(Iterator<? extends E> iterator) {
        Object object = this.mutex;
        synchronized (object) {
            this.pushAll_(iterator);
        }
    }

    private void pushAll_(Iterator<? extends E> iterator) {
        while (iterator.hasNext()) {
            this.push_(iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushAll(E ... array) {
        Object object = this.mutex;
        synchronized (object) {
            this.pushAll_(array);
        }
    }

    private void pushAll_(E[] array) {
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            this.push_(element);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushAll(Stack<? extends E> s) {
        Object object = this.mutex;
        synchronized (object) {
            this.pushAll_(s);
        }
    }

    private void pushAll_(Stack<? extends E> s) {
        while (!s.isEmpty()) {
            this.push_(s.pop());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushAll(Queue<? extends E> queue) {
        Object object = this.mutex;
        synchronized (object) {
            this.pushAll_(queue);
        }
    }

    private void pushAll_(Queue<? extends E> queue) {
        while (!queue.isEmpty()) {
            this.push_(queue.dequeue());
        }
    }

    public Iterable<E> popAll() {
        return this.popAllTo((Queue)((Object)new ArrayList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends Collection<? super E>> C popAllTo(C c) {
        Object object = this.mutex;
        synchronized (object) {
            return this.popAllTo_((Queue)((Object)c));
        }
    }

    private <C extends Collection<? super E>> C popAllTo_(C c) {
        boolean changed = false;
        while (!this.stack.isEmpty()) {
            c.add(this.stack.pop());
            changed = true;
        }
        if (changed) {
            this.mutex.notifyAll();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends Stack<? super E>> S popAllTo(S s) {
        Object object = this.mutex;
        synchronized (object) {
            return this.popAllTo_((Queue)((Object)s));
        }
    }

    private <S extends Stack<? super E>> S popAllTo_(S s) {
        boolean changed = false;
        while (!this.stack.isEmpty()) {
            s.push(this.stack.pop());
            changed = true;
        }
        if (changed) {
            this.mutex.notifyAll();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Q extends Queue<? super E>> Q popAllTo(Q queue) {
        Object object = this.mutex;
        synchronized (object) {
            return this.popAllTo_(queue);
        }
    }

    private <Q extends Queue<? super E>> Q popAllTo_(Q queue) {
        boolean changed = false;
        while (!this.stack.isEmpty()) {
            queue.enqueue(this.stack.pop());
            changed = true;
        }
        if (changed) {
            this.mutex.notifyAll();
        }
        return queue;
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return this.stack.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            s.defaultWriteObject();
        }
    }
}

