/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms;

import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.PossibleValues;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.xml.FoldingXmlValueBindingImpl;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;
import org.eclipse.sapphire.ui.def.internal.PropertyEditorDefMethods;
import org.eclipse.sapphire.ui.forms.ActuatorDef;
import org.eclipse.sapphire.ui.forms.CompositeDef;
import org.eclipse.sapphire.ui.forms.CustomFormComponentDef;
import org.eclipse.sapphire.ui.forms.DetailSectionDef;
import org.eclipse.sapphire.ui.forms.FormComponentDef;
import org.eclipse.sapphire.ui.forms.FormComponentRef;
import org.eclipse.sapphire.ui.forms.FormDef;
import org.eclipse.sapphire.ui.forms.GroupDef;
import org.eclipse.sapphire.ui.forms.HtmlPanelDef;
import org.eclipse.sapphire.ui.forms.LineSeparatorDef;
import org.eclipse.sapphire.ui.forms.SectionDef;
import org.eclipse.sapphire.ui.forms.SpacerDef;
import org.eclipse.sapphire.ui.forms.SplitFormDef;
import org.eclipse.sapphire.ui.forms.StaticTextFieldDef;
import org.eclipse.sapphire.ui.forms.TabGroupDef;
import org.eclipse.sapphire.ui.forms.TextDef;
import org.eclipse.sapphire.ui.forms.WithDef;

@Label(standard="property editor")
@Image(path="PropertyEditorDef.png")
@XmlBinding(path="property-editor")
public interface PropertyEditorDef
extends FormComponentDef {
    public static final ElementType TYPE = new ElementType(PropertyEditorDef.class);
    public static final String HINT_CHECKBOX_LAYOUT = "checkbox.layout";
    public static final String HINT_VALUE_CHECKBOX_LAYOUT_LEADING_LABEL = "leading.label";
    public static final String HINT_VALUE_CHECKBOX_LAYOUT_TRAILING_LABEL = "trailing.label";
    public static final String HINT_VALUE_CHECKBOX_LAYOUT_TRAILING_LABEL_INDENTED = "trailing.label.idented";
    public static final String HINT_SHOW_HEADER = "show.header";
    public static final String HINT_AUX_TEXT = "aux.text";
    public static final String HINT_AUX_TEXT_PROVIDER = "aux.text.provider";
    public static final String HINT_BROWSE_ONLY = "browse.only";
    public static final String HINT_READ_ONLY = "read.only";
    public static final String HINT_BORDER = "border";
    public static final String HINT_ASSIST_CONTRIBUTORS = "assist.contributors";
    public static final String HINT_SUPPRESS_ASSIST_CONTRIBUTORS = "suppress.assist.contributors";
    public static final String HINT_LISTENERS = "listeners";
    public static final String HINT_COLUMN_WIDTHS = "column.widths";
    public static final String HINT_FACTORY = "factory";
    @Label(standard="property")
    @Required
    @CustomXmlValueBinding(impl=FoldingXmlValueBindingImpl.class, params={"property"})
    public static final ValueProperty PROP_PROPERTY = new ValueProperty(TYPE, "Property");
    @Type(base=PropertyEditorDef.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="child-property", type=PropertyEditorDef.class)})
    @Label(standard="child properties")
    public static final ListProperty PROP_CHILD_PROPERTIES = new ListProperty(TYPE, "ChildProperties");
    @Type(base=FormComponentDef.class, possible={PropertyEditorDef.class, LineSeparatorDef.class, SpacerDef.class, TextDef.class, GroupDef.class, WithDef.class, CompositeDef.class, ActuatorDef.class, CustomFormComponentDef.class, StaticTextFieldDef.class, DetailSectionDef.class, TabGroupDef.class, HtmlPanelDef.class, FormComponentRef.class, FormDef.class, SplitFormDef.class, SectionDef.class})
    @XmlListBinding(path="related-content")
    public static final ListProperty PROP_RELATED_CONTENT = new ListProperty(TYPE, "RelatedContent");
    @Type(base=Integer.class)
    @Label(standard="related content width")
    @DefaultValue(text="40")
    @NumericRange(min="20", max="80")
    @XmlBinding(path="related-content-width")
    public static final ValueProperty PROP_RELATED_CONTENT_WIDTH = new ValueProperty(TYPE, "RelatedContentWidth");
    @Type(base=Boolean.class)
    @Label(standard="show label")
    @DefaultValue(text="true")
    @XmlBinding(path="show-label")
    @Documentation(content="Indicates whether the property editor label should be shown. The label can be hidden to reduce UI clutter if the property editor is already adequately described by its context.")
    public static final ValueProperty PROP_SHOW_LABEL = new ValueProperty(TYPE, "ShowLabel");
    @Type(base=Function.class)
    @Label(standard="label")
    @Enablement(expr="${ ShowLabel }")
    @XmlBinding(path="label")
    @Documentation(content="Overrides property editor label. By default, the property editor will use property's label from model metadata.")
    public static final ValueProperty PROP_LABEL = new ValueProperty(TYPE, "Label");
    @Type(base=Boolean.class)
    @Label(standard="span both columns")
    @DefaultValue(text="false")
    @XmlBinding(path="span")
    @Documentation(content="Indicates whether the body of the property editor should span both columns. If set to true, the property editor label will be shown above the body. The label itself would also span both columns.")
    public static final ValueProperty PROP_SPAN_BOTH_COLUMNS = new ValueProperty(TYPE, "SpanBothColumns");
    @Type(base=Integer.class)
    @Label(standard="width")
    @XmlBinding(path="width")
    @Documentation(content="Specifies the preferred width (in pixels) for the body of the property editor. The width preference will be respected to the extent that it is feasible.")
    public static final ValueProperty PROP_WIDTH = new ValueProperty(TYPE, "Width");
    @Type(base=Integer.class)
    @Label(standard="height")
    @XmlBinding(path="height")
    @Documentation(content="Specifies the preferred height (in pixels) for the body of the property editor. The height preference will be respected to the extent that it is feasible. In particular, the height preference is ignored by property editors that cannot scale vertically.")
    public static final ValueProperty PROP_HEIGHT = new ValueProperty(TYPE, "Height");
    @Type(base=Integer.class)
    @Label(standard="left margin")
    @DefaultValue(text="0")
    @NumericRange(min="0")
    @XmlBinding(path="margin-left")
    @Documentation(content="Specifies the preferred left margin (in pixels) for the body of the property editor. The left margin preference will be respected to the extent that it is feasible.")
    public static final ValueProperty PROP_MARGIN_LEFT = new ValueProperty(TYPE, "MarginLeft");
    @PossibleValues(values={"Sapphire.PropertyEditor.PopUpListField", "Sapphire.PropertyEditor.PopUpListField.Editable", "Sapphire.PropertyEditor.PopUpListField.Strict", "Sapphire.PropertyEditor.RadioButtonGroup", "Sapphire.PropertyEditor.RadioButtonGroup.Horizontal", "Sapphire.PropertyEditor.RadioButtonGroup.Vertical", "Sapphire.PropertyEditor.CheckBoxGroup", "Sapphire.PropertyEditor.CheckBoxGroup.Horizontal", "Sapphire.PropertyEditor.CheckBoxGroup.Vertical", "Sapphire.PropertyEditor.Scale"})
    public static final ValueProperty PROP_STYLE = new ValueProperty(TYPE, FormComponentDef.PROP_STYLE);

    public Value<String> getProperty();

    public void setProperty(String var1);

    public ElementList<PropertyEditorDef> getChildProperties();

    @DelegateImplementation(value=PropertyEditorDefMethods.class)
    public PropertyEditorDef getChildPropertyEditor(ModelPath var1);

    public ElementList<FormComponentDef> getRelatedContent();

    public Value<Integer> getRelatedContentWidth();

    public void setRelatedContentWidth(String var1);

    public void setRelatedContentWidth(Integer var1);

    public Value<Boolean> getShowLabel();

    public void setShowLabel(String var1);

    public void setShowLabel(Boolean var1);

    public Value<Function> getLabel();

    public void setLabel(String var1);

    public void setLabel(Function var1);

    public Value<Boolean> getSpanBothColumns();

    public void setSpanBothColumns(String var1);

    public void setSpanBothColumns(Boolean var1);

    public Value<Integer> getWidth();

    public void setWidth(String var1);

    public void setWidth(Integer var1);

    public Value<Integer> getHeight();

    public void setHeight(String var1);

    public void setHeight(Integer var1);

    public Value<Integer> getMarginLeft();

    public void setMarginLeft(String var1);

    public void setMarginLeft(Integer var1);
}

