/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.epp.internal.logging.aeri.ui.ConfigurationDialog;
import org.eclipse.epp.internal.logging.aeri.ui.Events;
import org.eclipse.epp.internal.logging.aeri.ui.INotificationService;
import org.eclipse.epp.internal.logging.aeri.ui.ReportDialog;
import org.eclipse.epp.internal.logging.aeri.ui.UploadHandler;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.log.ProblemsDatabaseService;
import org.eclipse.epp.internal.logging.aeri.ui.log.ReportHistory;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.ProblemStatus;
import org.eclipse.epp.internal.logging.aeri.ui.model.RememberSendAction;
import org.eclipse.epp.internal.logging.aeri.ui.model.SendAction;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Browsers;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Shells;
import org.eclipse.epp.internal.logging.aeri.ui.v2.AeriServer;
import org.eclipse.epp.internal.logging.aeri.ui.v2.ServerConfiguration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ReportingController {
    private static final long NOTIFICATION_IDLE_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(30L);
    private static final long CONFIGURATION_PROCESS_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(5L);
    private static final ProblemStatus UNKNOWN_STATUS = new ProblemStatus();
    private IObservableList queueUI;
    private LinkedList<ErrorReport> queueRO;
    private EventBus bus;
    private Settings settings;
    private INotificationService notifications;
    private boolean configureInProgress;
    private long configureInProgressTimeout = Long.MAX_VALUE;
    private boolean notificationInProgress;
    private long notificationInProgressTimeout = Long.MAX_VALUE;
    private ReportHistory history;
    private ProblemsDatabaseService problemsDb;
    private UploadHandler uploadHandler;
    private ServerConfiguration configuration;

    static {
        UNKNOWN_STATUS.setAction(ProblemStatus.RequiredAction.NONE);
    }

    public ReportingController(EventBus bus, Settings settings, ServerConfiguration configuration, AeriServer server, INotificationService notifications, ReportHistory history, ProblemsDatabaseService problemsDb) {
        this.bus = bus;
        this.settings = settings;
        this.configuration = configuration;
        this.notifications = notifications;
        this.history = history;
        this.problemsDb = problemsDb;
        this.uploadHandler = new UploadHandler(settings, configuration, server, history, bus);
        this.initalizeLists();
    }

    protected void initalizeLists() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ReportingController.this.queueRO = Lists.newLinkedList();
                ReportingController.this.queueUI = Properties.selfList(ErrorReport.class).observe((Object)ReportingController.this.queueRO);
            }
        });
    }

    @Subscribe
    public synchronized void on(Events.NewReportLogged e) {
        ErrorReport report = e.report;
        this.addToQueue(report);
        if (!this.isConfigured()) {
            if (!this.isConfigureInProgress()) {
                this.requestShowConfigureDialog();
            }
            return;
        }
        ProblemStatus status = (ProblemStatus)this.problemsDb.seen(report).or((Object)UNKNOWN_STATUS);
        switch (status.getAction()) {
            case NEEDINFO: {
                this.requestShowNeedInfoRequest(report, status);
                break;
            }
            case FIXED: {
                this.requestShowFixedInfo(report, status);
                break;
            }
            case NONE: {
                this.sendOrNotify(report);
                break;
            }
        }
    }

    private void sendOrNotify(ErrorReport report) {
        if (this.isSentSilently()) {
            this.requestSendSilently();
        } else if (!this.isNotificationInProgress()) {
            this.requestShowNewReportNotification(report);
        }
    }

    private void requestShowNeedInfoRequest(ErrorReport report, ProblemStatus seen) {
        this.bus.post((Object)new Events.NeedInfoRequest(report, seen));
    }

    private void requestShowFixedInfo(ErrorReport report, ProblemStatus status) {
        this.bus.post((Object)new Events.BugIsFixedInfo(report, status));
    }

    private void requestSendSilently() {
        this.bus.post((Object)new Events.SendReportsRequest());
    }

    private boolean isSentSilently() {
        return Objects.equal((Object)((Object)this.settings.getAction()), (Object)((Object)SendAction.SILENT));
    }

    private void addToQueue(final ErrorReport report) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ReportingController.this.queueUI.add((Object)report);
            }
        };
        this.runAsync(run);
    }

    private void clearIncoming() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ReportingController.this.queueUI.clear();
            }
        };
        this.runAsync(run);
    }

    private void runAsync(Runnable run) {
        if (Shells.isUIThread()) {
            run.run();
        } else {
            Optional<Display> display = Shells.getDisplay();
            if (display.isPresent()) {
                ((Display)display.get()).asyncExec(run);
            } else {
                Logs.log(LogMessages.WARN_ILLEGAL_STATE_NO_DISPLAY);
            }
        }
    }

    private boolean isConfigured() {
        return this.settings.isConfigured();
    }

    private boolean isConfigureInProgress() {
        if (this.isConfigurationProcessTimedOut()) {
            this.resetConfigureRequestTimeout();
            this.setConfigureInProgress(false);
            Logs.log(LogMessages.WARN_CONFIGURATION_TIMED_OUT);
        }
        return this.configureInProgress;
    }

    private boolean isConfigurationProcessTimedOut() {
        return System.currentTimeMillis() > this.configureInProgressTimeout;
    }

    private long resetConfigureRequestTimeout() {
        this.configureInProgressTimeout = Long.MAX_VALUE;
        return Long.MAX_VALUE;
    }

    private void setConfigureInProgress(boolean configureInProgress) {
        this.configureInProgress = configureInProgress;
    }

    private void requestShowConfigureDialog() {
        this.setConfigureInProgress(true);
        this.configureInProgressTimeout = System.currentTimeMillis() + CONFIGURATION_PROCESS_TIMEOUT_MS;
        this.notifications.showWelcomeNotification();
    }

    private void requestShowNewReportNotification(ErrorReport e) {
        this.setNotificationInProgress(true);
        this.setNotificationInProgressTimeout();
        this.notifications.showNewReportsAvailableNotification(e);
    }

    private boolean isNotificationInProgress() {
        if (this.isNotificationTimedOut()) {
            this.resetNotificationInProgress();
            this.setNotificationInProgress(false);
            Logs.log(LogMessages.WARN_NOTIFICATION_TIMED_OUT);
        }
        return this.notificationInProgress;
    }

    private boolean isNotificationTimedOut() {
        return System.currentTimeMillis() > this.notificationInProgressTimeout;
    }

    private void setNotificationInProgress(boolean newValue) {
        this.notificationInProgress = newValue;
    }

    private void setNotificationInProgressTimeout() {
        this.notificationInProgressTimeout = System.currentTimeMillis() + NOTIFICATION_IDLE_TIMEOUT_MS;
    }

    private long resetNotificationInProgress() {
        this.notificationInProgressTimeout = Long.MAX_VALUE;
        return Long.MAX_VALUE;
    }

    @VisibleForTesting
    public void scheduleForSending(List<ErrorReport> reports) {
        this.uploadHandler.scheduleForSending(reports);
    }

    @Subscribe
    public void on(Events.ConfigureShowDialogRequest e) {
        Shell shell = (Shell)Shells.getWorkbenchWindowShell().orNull();
        ConfigurationDialog dialog = new ConfigurationDialog(shell, this.settings, this.configuration);
        dialog.setBlockOnOpen(true);
        int status = dialog.open();
        switch (status) {
            case 0: {
                this.bus.post((Object)new Events.ConfigureDialogCompleted(SendAction.ASK));
                break;
            }
            case 1: {
                this.bus.post((Object)new Events.ConfigureDialogCompleted(SendAction.IGNORE));
                break;
            }
            case 84: {
                this.bus.post((Object)new Events.ConfigureDialogCanceled());
                break;
            }
            default: {
                this.bus.post((Object)new Events.ConfigureDialogCanceled());
            }
        }
    }

    @Subscribe
    public void on(Events.ConfigureDialogCompleted e) {
        this.settings.setAction(e.selectedAction);
        this.settings.setConfigured(true);
        this.setConfigureInProgress(false);
        if (e.selectedAction == SendAction.IGNORE) {
            this.clearIncoming();
        } else if (!this.queueRO.isEmpty()) {
            ErrorReport peek = this.queueRO.peek();
            this.bus.post((Object)new Events.NewReportShowNotificationRequest(peek));
        }
    }

    @Subscribe
    public void on(Events.ConfigureDialogCanceled e) {
        this.settings.setAction(SendAction.IGNORE);
        this.settings.setRememberSendAction(RememberSendAction.RESTART);
        this.settings.setConfigured(false);
        this.setConfigureInProgress(false);
    }

    @Subscribe
    public void on(Events.ConfigurePopupDisableRequested e) {
        this.setConfigureInProgress(false);
        this.settings.setConfigured(true);
        this.settings.setAction(SendAction.IGNORE);
    }

    @Subscribe
    public void on(Events.ConfigureRequestTimedOut e) {
        this.setConfigureInProgress(false);
        this.resetConfigureRequestTimeout();
    }

    @Subscribe
    public void on(Events.NewReportShowNotificationRequest e) {
        this.setNotificationInProgress(true);
        this.notifications.showNewReportsAvailableNotification(e.report);
    }

    @Subscribe
    public void on(Events.NewReportShowDetailsRequest e) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ReportDialog d = new ReportDialog((Shell)Shells.getWorkbenchWindowShell().orNull(), ReportingController.this.settings, ReportingController.this.configuration, ReportingController.this.queueUI, ReportingController.this.bus);
                d.setBlockOnOpen(true);
                int status = d.open();
                ReportingController.this.setNotificationInProgress(false);
                switch (status) {
                    case 0: {
                        ReportingController.this.requestSendSilently();
                        break;
                    }
                    case 1: {
                        for (Object report : ReportingController.this.queueUI) {
                            ReportingController.this.bus.post((Object)new Events.NewReportNotificationSkipped((ErrorReport)report));
                        }
                        break;
                    }
                }
            }
        };
        this.runAsync(run);
    }

    @Subscribe
    public void on(Events.NewReportNotificationSkipped e) {
        this.setNotificationInProgress(false);
        this.history.remember(e.report);
        this.clearIncoming();
    }

    @Subscribe
    public void on(Events.NewReportNotificationTimedOut e) {
        this.setNotificationInProgress(false);
        this.resetNotificationInProgress();
        this.clearIncoming();
    }

    @Subscribe
    public void on(Events.NeedInfoRequest e) {
        this.setNotificationInProgress(true);
        this.setNotificationInProgressTimeout();
        this.notifications.showNeedInfoNotification(e.report, e.status);
    }

    @Subscribe
    public void on(Events.BugIsFixedInfo e) {
        this.setNotificationInProgress(true);
        this.setNotificationInProgressTimeout();
        this.notifications.showBugFixedInfo(e.report, e.status);
    }

    @Subscribe
    public void on(Events.SendReportsRequest e) {
        ImmutableList tmp = ImmutableList.copyOf(this.queueRO);
        this.clearIncoming();
        this.setNotificationInProgress(false);
        this.scheduleForSending((List<ErrorReport>)tmp);
    }

    @Subscribe
    public void on(Events.ServerResponseShowRequest e) {
        if (this.isNotificationInProgress()) {
            return;
        }
        this.setNotificationInProgressTimeout();
        this.setNotificationInProgress(true);
        this.notifications.showNewResponseNotification(e.response);
    }

    @Subscribe
    public void on(Events.ServerResponseNotificationTimedOut e) {
        this.setNotificationInProgress(false);
    }

    @Subscribe
    public void on(Events.OpenUrlInBrowserRequest e) {
        this.setNotificationInProgress(false);
        if (!StringUtils.isEmpty((CharSequence)e.url)) {
            Browsers.openInExternalBrowser(e.url);
        }
    }
}

