/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class WildcardRegexConverter {
    private static final String QUOTE_START = "\\Q";
    private static final String QUOTE_END = "\\E";
    private static final String WILDCARD_PATTERN = ".*";

    public static Pattern convert(String string) {
        StringBuilder b = new StringBuilder();
        b.append(QUOTE_START);
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '*') {
                b.append(QUOTE_END);
                b.append(WILDCARD_PATTERN);
                b.append(QUOTE_START);
            } else {
                b.append(c);
            }
            ++n2;
        }
        b.append(QUOTE_END);
        return Pattern.compile(b.toString());
    }

    public static List<Pattern> convert(Collection<String> wildcardStrings) {
        ArrayList patterns = Lists.newArrayList();
        for (String s : wildcardStrings) {
            patterns.add(WildcardRegexConverter.convert(s));
        }
        return patterns;
    }
}

