/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui;

import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.xml.search.ui.LiferayXMLSearchUI;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;

public class PortalLanguagePropertiesCacheUtil {
    private static final WeakHashMap<IPath, Properties> languagePortalMap = new WeakHashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties getPortalLanguageProperties(ILiferayProject project) {
        InputStream in;
        ZipFile jar;
        Properties retval;
        block20: {
            ILiferayPortal portal;
            block19: {
                if (project == null) {
                    return new Properties();
                }
                retval = null;
                jar = null;
                in = null;
                portal = (ILiferayPortal)project.adapt(ILiferayPortal.class);
                if (portal != null) break block19;
                Properties properties = retval;
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (jar == null) return properties;
                    jar.close();
                    return properties;
                }
                catch (IOException iOException) {}
                return properties;
            }
            try {
                try {
                    IPath appServerPortalDir = portal.getAppServerPortalDir();
                    retval = languagePortalMap.get(appServerPortalDir);
                    if (retval != null) break block20;
                    if (appServerPortalDir != null && appServerPortalDir.toFile().exists()) {
                        jar = new JarFile(appServerPortalDir.append("WEB-INF/lib/portal-impl.jar").toFile());
                        ZipEntry lang = ((JarFile)jar).getEntry("content/Language.properties");
                        retval = new Properties();
                        in = ((JarFile)jar).getInputStream(lang);
                        retval.load(in);
                    }
                    languagePortalMap.put(appServerPortalDir, retval);
                }
                catch (Exception e) {
                    LiferayXMLSearchUI.logError("Unable to find portal language properties", e);
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (jar == null) return retval;
                        jar.close();
                        return retval;
                    }
                    catch (IOException iOException) {}
                    return retval;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (jar == null) throw throwable;
                    jar.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            if (in != null) {
                in.close();
            }
            if (jar == null) return retval;
            jar.close();
            return retval;
        }
        catch (IOException iOException) {}
        return retval;
    }
}

