/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui.java;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.wst.xml.search.core.xpath.NamespaceInfos;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.classnameprovider.AbstractClassNameExtractor;
import org.w3c.dom.Node;

public class HierarchyTypeClassNameExtractor
extends AbstractClassNameExtractor {
    private final String typeName;

    public HierarchyTypeClassNameExtractor(String typeName) {
        this.typeName = typeName;
    }

    protected String[] doExtractClassNames(Node node, IFile file, String pathForClass, String findByAttrName, boolean findByParentNode, String xpathFactoryProviderId, NamespaceInfos namespaceInfo) throws XPathExpressionException {
        String[] retval = null;
        IJavaProject project = JavaCore.create((IProject)file.getProject());
        try {
            IType type = project.findType(this.typeName);
            if (type != null) {
                TypeNameRequestor requestor = new TypeNameRequestor();
                IJavaSearchScope scope = SearchEngine.createStrictHierarchyScope((IJavaProject)project, (IType)type, (boolean)true, (boolean)false, null);
                SearchPattern search = SearchPattern.createPattern((String)"*", (int)5, (int)0, (int)0);
                new SearchEngine().search(search, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
                retval = requestor.getResults().toArray(new String[0]);
            }
        }
        catch (Exception exception) {}
        return retval;
    }

    private static class TypeNameRequestor
    extends SearchRequestor {
        private final List<String> results = new ArrayList<String>();

        private TypeNameRequestor() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object element = match.getElement();
            if (element instanceof IType) {
                IType type = (IType)element;
                this.results.add(type.getFullyQualifiedName());
            }
        }

        List<String> getResults() {
            return this.results;
        }
    }
}

