/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui.resources;

import com.liferay.ide.core.util.CoreUtil;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.xml.search.core.resource.ResourceBaseURIResolver;

public class ResourceBundleURIResolver
extends ResourceBaseURIResolver {
    public static final ResourceBundleURIResolver INSTANCE = new ResourceBundleURIResolver();
    private static final Set<String> EXTENSIONS = new HashSet<String>();

    static {
        EXTENSIONS.add("properties");
    }

    protected Set<String> getExtensions() {
        return EXTENSIONS;
    }

    public boolean accept(Object selectedNode, IResource rootContainer, IResource file, String matching, boolean fullMatch) {
        String extension = file.getFileExtension();
        if (CoreUtil.isNullOrEmpty((String)extension) || !this.getExtensions().contains(extension.toLowerCase())) {
            return false;
        }
        if (matching != null) {
            String uri = this.resolve(selectedNode, rootContainer, file);
            if (fullMatch) {
                return uri.equals(matching);
            }
            return uri.startsWith(matching);
        }
        return false;
    }

    public String resolve(Object selectedNode, IResource rootContainer, IResource file) {
        String uri = super.resolve(selectedNode, rootContainer, file);
        return uri.substring(0, uri.lastIndexOf(".properties")).replaceAll("/", ".");
    }
}

