/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.action;

import com.liferay.ide.gradle.core.GradleUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.ui.action.AbstractObjectAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class GradleTaskAction
extends AbstractObjectAction {
    protected abstract String getGradleTask();

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            Object[] elems = ((IStructuredSelection)this.fSelection).toArray();
            IFile gradleBuildFile = null;
            IProject project = null;
            Object elem = elems[0];
            if (elem instanceof IFile) {
                gradleBuildFile = (IFile)elem;
                project = gradleBuildFile.getProject();
            } else if (elem instanceof IProject) {
                project = (IProject)elem;
                gradleBuildFile = project.getFile("build.gradle");
            }
            if (gradleBuildFile.exists()) {
                final IProject p = project;
                Job job = new Job(String.valueOf(p.getName()) + " - " + this.getGradleTask()){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            monitor.beginTask(GradleTaskAction.this.getGradleTask(), 100);
                            GradleUtil.runGradleTask((IProject)p, (String)GradleTaskAction.this.getGradleTask(), (IProgressMonitor)monitor);
                            monitor.worked(80);
                            p.refreshLocal(2, monitor);
                            monitor.worked(10);
                            GradleTaskAction.this.updateProject(p, monitor);
                            monitor.worked(10);
                        }
                        catch (Exception e) {
                            return ProjectUI.createErrorStatus((String)("Error running Gradle goal " + GradleTaskAction.this.getGradleTask()), (Exception)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    }

    protected void updateProject(IProject p, IProgressMonitor monitor) {
        try {
            p.refreshLocal(2, monitor);
        }
        catch (CoreException coreException) {}
    }
}

