/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.PortalServerConstants;
import com.liferay.ide.server.core.portal.PortalServerWorkingCopy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.model.ServerDelegate;

public class PortalServerDelegate
extends ServerDelegate
implements PortalServerWorkingCopy {
    private static final List<String> SUPPORT_TYPES_LIST = Arrays.asList("liferay.bundle", "jst.web", "jst.utility");
    private int nextAgentPort = 29999;

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        IStatus retval = Status.OK_STATUS;
        if (!CoreUtil.isNullOrEmpty((Object[])add)) {
            IModule[] iModuleArray = add;
            int n = add.length;
            int n2 = 0;
            while (n2 < n) {
                IModule module = iModuleArray[n2];
                if (!SUPPORT_TYPES_LIST.contains(module.getModuleType().getId())) {
                    retval = LiferayServerCore.error("Unable to add module with type " + module.getModuleType().getName());
                    break;
                }
                ++n2;
            }
        }
        return retval;
    }

    @Override
    public int getAutoPublishTime() {
        return this.getAttribute("auto-publish-time", 0);
    }

    public IModule[] getChildModules(IModule[] module) {
        IModule[] retval = null;
        if (module != null) {
            IModuleType moduleType = module[0].getModuleType();
            if (module.length == 1 && moduleType != null && SUPPORT_TYPES_LIST.contains(moduleType.getId())) {
                retval = new IModule[]{};
            }
        }
        return retval;
    }

    @Override
    public boolean getDeveloperMode() {
        return this.getAttribute("developerMode", false);
    }

    @Override
    public String getExternalProperties() {
        return this.getAttribute("externalProperties", "");
    }

    @Override
    public boolean getLaunchSettings() {
        return this.getAttribute("launchSettings", true);
    }

    @Override
    public String getHttpPort() {
        return "8080";
    }

    @Override
    public String getHost() {
        return this.getServer().getHost();
    }

    @Override
    public String getId() {
        return this.getServer().getId();
    }

    @Override
    public void setLaunchSettings(boolean launchSettings) {
        this.setAttribute("launchSettings", launchSettings);
    }

    @Override
    public String[] getMemoryArgs() {
        String[] retval = null;
        String args = this.getAttribute("memoryArgs", PortalServerConstants.DEFAULT_MEMORY_ARGS);
        if (!CoreUtil.isNullOrEmpty((String)args)) {
            retval = args.split(" ");
        }
        return retval;
    }

    @Override
    public String getPassword() {
        return this.getAttribute("password", DEFAULT_PASSWORD);
    }

    @Override
    public URL getPluginContextURL(String context) {
        try {
            return new URL(this.getPortalHomeUrl(), "/" + context);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public URL getPortalHomeUrl() {
        try {
            return new URL("http://localhost:8080");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        IStatus status = this.canModifyModules(new IModule[]{module}, null);
        if (status == null || !status.isOK()) {
            throw new CoreException(status);
        }
        return new IModule[]{module};
    }

    @Override
    public String getUsername() {
        return this.getAttribute("username", DEFAULT_USERNAME);
    }

    @Override
    public URL getWebServicesListURL() {
        try {
            return new URL(this.getPortalHomeUrl(), "/tunnel-web/axis");
        }
        catch (MalformedURLException e) {
            LiferayServerCore.logError("Unable to get web services list URL", e);
            return null;
        }
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
    }

    public void setDefaults(IProgressMonitor monitor) {
        this.setAttribute("auto-publish-time", this.getAutoPublishTime());
        this.setAttribute("AGENT_PORT", this.nextAgentPort++);
    }

    @Override
    public void setDeveloperMode(boolean developerMode) {
        this.setAttribute("developerMode", developerMode);
    }

    @Override
    public void setExternalProperties(String externalProperties) {
        this.setAttribute("externalProperties", externalProperties);
    }

    @Override
    public void setMemoryArgs(String memoryArgs) {
        this.setAttribute("memoryArgs", memoryArgs);
    }

    @Override
    public void setPassword(String password) {
        this.setAttribute("password", password);
    }

    @Override
    public void setUsername(String username) {
        this.setAttribute("username", username);
    }
}

