/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.HashSet;
import java.util.List;
import org.eclipse.sapphire.Disposable;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementData;
import org.eclipse.sapphire.ElementImpl;
import org.eclipse.sapphire.EnablementService;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.EventDeliveryJob;
import org.eclipse.sapphire.Filter;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.JobQueue;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Observable;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyEnablementEvent;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.PropertyValidationEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.internal.NonSuspendableListener;
import org.eclipse.sapphire.modeling.ElementDisposeEvent;
import org.eclipse.sapphire.modeling.ElementEvent;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.ClearOnDisable;
import org.eclipse.sapphire.services.DependenciesService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.sapphire.services.internal.PropertyInstanceServiceContext;

public abstract class Property
implements Observable {
    private static final int INITIALIZED = 1;
    private static final int ENABLEMENT_INITIALIZED = 2;
    private static final int VALIDATION_INITIALIZED = 4;
    protected static final int CONTENT_INITIALIZED = 8;
    @Text(value="{0} property is already disposed.")
    private static LocalizableText propertyAlreadyDisposed;
    @Text(value="Path \"{2}\" is invalid for {0}#{1}.")
    private static LocalizableText illegalPathException;
    private final Element element;
    private final PropertyDef definition;
    private PropertyInstanceServiceContext services;
    private ListenerContext listeners;
    private boolean enablement;
    private Status validation;
    protected byte initialization;
    private boolean disposed = false;

    static {
        LocalizableText.init(Property.class);
    }

    public Property(Element element, PropertyDef property) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.element = element;
        if (property == null) {
            throw new IllegalArgumentException();
        }
        this.definition = property;
    }

    protected final void init() {
        this.assertNotDisposed();
        if ((this.initialization & 1) == 0) {
            this.initialization = (byte)(this.initialization | 1);
            for (Listener listener : this.definition().listeners()) {
                this.attach(listener);
            }
            final Listener triggerRefreshListener = new Listener(){

                @Override
                public void handle(Event event) {
                    if (!Property.this.disposed()) {
                        Property.this.refresh();
                    }
                }
            };
            final HashSet<ModelPath> dependencies = new HashSet<ModelPath>();
            for (DependenciesService ds : this.services(DependenciesService.class)) {
                dependencies.addAll(ds.dependencies());
            }
            if (!dependencies.isEmpty()) {
                for (ModelPath dependency : dependencies) {
                    this.element().attach(triggerRefreshListener, dependency);
                }
                FilteredListener<ElementDisposeEvent> disposeListener = new FilteredListener<ElementDisposeEvent>(){

                    @Override
                    protected void handleTypedEvent(ElementDisposeEvent event) {
                        for (ModelPath dependency : dependencies) {
                            Property.this.element().detach(triggerRefreshListener, dependency);
                        }
                    }
                };
                this.element().attach(disposeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void refreshEnablement(boolean onlyIfNotInitialized) {
        boolean initialized;
        Property property = this;
        synchronized (property) {
            initialized = (this.initialization & 2) != 0;
        }
        if (!initialized || !onlyIfNotInitialized) {
            boolean after = true;
            if (!initialized) {
                Listener listener = new Listener(){

                    @Override
                    public void handle(Event event) {
                        Property.this.refreshEnablement(false);
                    }
                };
                for (EnablementService service : this.services(EnablementService.class)) {
                    service.attach(listener);
                }
                if (this.definition().hasAnnotation(ClearOnDisable.class)) {
                    FilteredListener<PropertyEnablementEvent> clearOnDisableListener = new FilteredListener<PropertyEnablementEvent>(){

                        @Override
                        protected void handleTypedEvent(PropertyEnablementEvent event) {
                            if (event.before() && !event.after()) {
                                Property.this.clear();
                            }
                        }
                    };
                    this.attach(clearOnDisableListener);
                }
            }
            for (EnablementService service : this.services(EnablementService.class)) {
                boolean bl = after = after && service.enablement();
                if (!after) break;
            }
            PropertyEnablementEvent event = null;
            Property property2 = this;
            synchronized (property2) {
                boolean bl = initialized = (this.initialization & 2) != 0;
                if (initialized) {
                    boolean before = this.enablement;
                    if (before != after) {
                        this.enablement = after;
                        event = new PropertyEnablementEvent(this, before, after);
                    }
                } else {
                    this.enablement = after;
                    this.initialization = (byte)(this.initialization | 2);
                }
            }
            this.broadcast(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final void refreshValidation(boolean onlyIfNotInitialized) {
        boolean initialized;
        Property property = this;
        synchronized (property) {
            initialized = (this.initialization & 4) != 0;
        }
        if (!initialized || !onlyIfNotInitialized) {
            void var5_10;
            Status.CompositeStatusFactory freshValidationResultFactory = Status.factoryForComposite();
            if (!initialized) {
                Listener listener = new Listener(){

                    @Override
                    public void handle(Event event) {
                        Property.this.refreshValidation(false);
                    }
                };
                for (ValidationService validationService : this.services(ValidationService.class)) {
                    validationService.attach(listener);
                }
            }
            for (ValidationService service : this.services(ValidationService.class)) {
                freshValidationResultFactory.merge(service.validation());
            }
            Status freshValidationResult = freshValidationResultFactory.create();
            Object var5_8 = null;
            Property property2 = this;
            synchronized (property2) {
                boolean bl = initialized = (this.initialization & 4) != 0;
                if (initialized) {
                    Status staleValidationResult = this.validation;
                    if (!staleValidationResult.equals(freshValidationResult)) {
                        this.validation = freshValidationResult;
                        PropertyValidationEvent propertyValidationEvent = new PropertyValidationEvent(this, staleValidationResult, freshValidationResult);
                    }
                } else {
                    this.validation = freshValidationResult;
                    this.initialization = (byte)(this.initialization | 4);
                }
            }
            this.broadcast((Event)var5_10);
        }
    }

    public final Element root() {
        return this.element.root();
    }

    public final Element element() {
        return this.element;
    }

    public boolean holds(Element element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        Property p = element.parent();
        while (p != null) {
            if (this == p) {
                return true;
            }
            p = p.element().parent();
        }
        return false;
    }

    public boolean holds(Property property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        Property p = property;
        while (p != null) {
            if (this == p) {
                return true;
            }
            p = p.element().parent();
        }
        return false;
    }

    public PropertyDef definition() {
        return this.definition;
    }

    public final String name() {
        return this.definition.name();
    }

    public final <T> T nearest(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return type.cast(this);
        }
        return this.element().nearest(type);
    }

    protected PropertyBinding binding() {
        return this.element().resource().binding(this);
    }

    public abstract void clear();

    public abstract void copy(Element var1);

    public abstract void copy(ElementData var1);

    public abstract boolean empty();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean enabled() {
        this.init();
        this.refreshEnablement(true);
        Property property = this;
        synchronized (property) {
            return this.enablement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Status validation() {
        this.init();
        this.refreshValidation(true);
        Property property = this;
        synchronized (property) {
            return this.validation;
        }
    }

    public abstract void refresh();

    public final <S extends Service> S service(Class<S> type) {
        this.assertNotDisposed();
        if (type == null) {
            throw new IllegalArgumentException();
        }
        List<S> services = this.services(type);
        return (S)(services.isEmpty() ? null : (Service)services.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <S extends Service> List<S> services(Class<S> type) {
        this.assertNotDisposed();
        if (type == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            if (this.services == null) {
                this.services = new PropertyInstanceServiceContext(this, ((ElementImpl)this.element()).queue());
            }
            return this.services.services(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenerContext listeners(boolean createIfNecessary) {
        Element root;
        Element element = root = this.root();
        synchronized (element) {
            if (this.listeners == null && createIfNecessary) {
                this.assertNotDisposed();
                this.listeners = new ListenerContext(((ElementImpl)root).queue());
            }
            return this.listeners;
        }
    }

    @Override
    public final void attach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners(true).attach(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void attach(Listener listener, String path) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (path == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            this.assertNotDisposed();
            this.attach(listener, new ModelPath(path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(Listener listener, ModelPath path) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (path == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            this.assertNotDisposed();
            if (path.length() == 0) {
                this.attach(listener);
            } else {
                ModelPath.Segment head = path.head();
                if (head instanceof ModelPath.AllDescendentsSegment) {
                    this.attach(listener);
                } else if (head instanceof ModelPath.ModelRootSegment) {
                    this.root().attach(listener, path.tail());
                } else if (head instanceof ModelPath.ParentElementSegment) {
                    Property parent = this.element().parent();
                    if (parent == null) {
                        throw this.createIllegalPathException(path);
                    }
                    parent.element().attach(listener, path.tail());
                } else {
                    throw this.createIllegalPathException(path);
                }
            }
        }
    }

    @Override
    public final void detach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        ListenerContext listeners = this.listeners(false);
        if (listeners != null) {
            listeners.detach(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void detach(Listener listener, String path) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (path == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            this.detach(listener, new ModelPath(path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(Listener listener, ModelPath path) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (path == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            if (path.length() == 0) {
                this.detach(listener);
            } else {
                ModelPath.Segment head = path.head();
                if (head instanceof ModelPath.AllDescendentsSegment) {
                    this.detach(listener);
                } else if (head instanceof ModelPath.ModelRootSegment) {
                    this.root().detach(listener, path.tail());
                } else if (head instanceof ModelPath.ParentElementSegment) {
                    Property parent = this.element().parent();
                    if (parent == null) {
                        throw this.createIllegalPathException(path);
                    }
                    parent.element().detach(listener, path.tail());
                } else {
                    throw this.createIllegalPathException(path);
                }
            }
        }
    }

    protected final void broadcast(Event event) {
        ListenerContext listeners;
        if (event != null && (listeners = this.listeners(false)) != null) {
            listeners.broadcast(event);
        }
    }

    public final Disposable suspend() {
        final JobQueue<EventDeliveryJob> queue = this.listeners(true).queue();
        final Disposable suspension = queue.suspend(new SuspendFilter());
        return new Disposable(){

            @Override
            public void dispose() {
                suspension.dispose();
                queue.process();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean disposed() {
        Element element = this.root();
        synchronized (element) {
            return this.disposed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dispose() {
        Element element = this.root();
        synchronized (element) {
            if (!this.disposed) {
                this.disposed = true;
                if (this.services != null) {
                    this.services.dispose();
                    this.services = null;
                }
                this.disposeOther();
                this.listeners = null;
                this.validation = null;
            }
        }
    }

    protected void disposeOther() {
    }

    protected final void assertNotDisposed() {
        if (this.disposed()) {
            String msg = propertyAlreadyDisposed.format(this.definition.name());
            throw new IllegalStateException(msg);
        }
    }

    protected final IllegalArgumentException createIllegalPathException(ModelPath path) {
        String message = illegalPathException.format(this.element().type().getModelElementClass().getName(), this.name(), path.toString());
        return new IllegalArgumentException(message);
    }

    private final class SuspendFilter
    implements Filter<EventDeliveryJob> {
        private SuspendFilter() {
        }

        @Override
        public boolean allows(EventDeliveryJob job) {
            if (!(job.listener() instanceof NonSuspendableListener)) {
                Event event = job.event();
                if (event instanceof PropertyEvent) {
                    return !Property.this.holds(((PropertyEvent)event).property());
                }
                if (event instanceof ElementEvent) {
                    return !Property.this.holds(((ElementEvent)event).element());
                }
            }
            return true;
        }
    }
}

