/*
 * Decompiled with CFR 0.152.
 */
package tern.server.nodejs;

import com.eclipsesource.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import tern.ITernProject;
import tern.TernException;
import tern.TernResourcesManager;
import tern.server.AbstractTernServer;
import tern.server.IInterceptor;
import tern.server.IResponseHandler;
import tern.server.ITernServer;
import tern.server.nodejs.NodejsTernHelper;
import tern.server.nodejs.process.INodejsProcess;
import tern.server.nodejs.process.INodejsProcessListener;
import tern.server.nodejs.process.NodejsProcessAdapter;
import tern.server.nodejs.process.NodejsProcessException;
import tern.server.nodejs.process.NodejsProcessManager;
import tern.server.protocol.IJSONObjectHelper;
import tern.server.protocol.MinimalJSONHelper;
import tern.server.protocol.TernDoc;
import tern.server.protocol.html.ScriptTagRegion;

public class NodejsTernServer
extends AbstractTernServer {
    private static final String BASE_URL = "http://127.0.0.1:";
    private String baseURL;
    private List<IInterceptor> interceptors;
    private INodejsProcess process;
    private List<INodejsProcessListener> listeners;
    private long timeout = 200L;
    private int testNumber = 50;
    private final INodejsProcessListener listener = new NodejsProcessAdapter(){

        @Override
        public void onStart(INodejsProcess server) {
            NodejsTernServer.this.fireStartServer();
        }

        @Override
        public void onStop(INodejsProcess server) {
            NodejsTernServer.this.dispose();
            NodejsTernServer.this.fireEndServer();
        }
    };
    private boolean persistent;

    public NodejsTernServer(File projectDir, int port) {
        this(TernResourcesManager.getTernProject((Object)projectDir), port);
    }

    public NodejsTernServer(ITernProject project, int port) {
        super(project);
        this.baseURL = this.computeBaseURL(port);
    }

    public NodejsTernServer(ITernProject project) throws TernException {
        this(project, NodejsProcessManager.getInstance().create(project.getProjectDir()));
    }

    public NodejsTernServer(ITernProject project, File nodejsBaseDir) throws TernException {
        this(project, NodejsProcessManager.getInstance().create(project.getProjectDir(), nodejsBaseDir));
    }

    public NodejsTernServer(ITernProject project, File nodejsBaseDir, File nodejsTernBaseDir) throws TernException {
        this(project, NodejsProcessManager.getInstance().create(project.getProjectDir(), nodejsBaseDir, nodejsTernBaseDir));
    }

    public NodejsTernServer(ITernProject project, INodejsProcess process) {
        super(project);
        this.process = process;
        process.addProcessListener(this.listener);
        this.initProcess(process);
    }

    private String computeBaseURL(Integer port) {
        return BASE_URL + port + "/";
    }

    public void addFile(String name, String text, ScriptTagRegion[] tags) {
        TernDoc t = new TernDoc();
        t.addFile(name, text, tags, null);
        try {
            this.makeRequest(t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void request(TernDoc doc, IResponseHandler handler) {
        try {
            JsonObject json = this.makeRequest(doc);
            handler.onSuccess((Object)json, handler.isDataAsJsonString() ? json.toString() : null);
        }
        catch (Exception e) {
            handler.onError(e.getMessage(), (Throwable)e);
        }
    }

    private JsonObject makeRequest(TernDoc doc) throws IOException, InterruptedException, TernException {
        ArrayList<IInterceptor> interceptors;
        String baseURL = null;
        try {
            baseURL = this.getBaseURL();
            if (baseURL == null) {
                throw new TernException("Server has been disposed");
            }
        }
        catch (NodejsProcessException e) {
            this.dispose();
            throw e;
        }
        this.beginReadState();
        try {
            interceptors = this.interceptors != null ? new ArrayList<IInterceptor>(this.interceptors) : null;
        }
        finally {
            this.endReadState();
        }
        JsonObject json = NodejsTernHelper.makeRequest(baseURL, doc, false, interceptors, (ITernServer)this);
        return json;
    }

    public void addInterceptor(IInterceptor interceptor) {
        this.beginWriteState();
        try {
            if (this.interceptors == null) {
                this.interceptors = new ArrayList<IInterceptor>();
            }
            this.interceptors.add(interceptor);
        }
        finally {
            this.endWriteState();
        }
    }

    public void removeInterceptor(IInterceptor interceptor) {
        this.beginWriteState();
        try {
            if (this.interceptors != null) {
                this.interceptors.remove(interceptor);
            }
        }
        finally {
            this.endWriteState();
        }
    }

    public String getBaseURL() throws InterruptedException, TernException {
        this.beginReadState();
        try {
            if (this.baseURL == null) {
                this.endReadState();
                this.beginWriteState();
                try {
                    if (this.baseURL != null || this.isDisposed()) {
                        String string = this.baseURL;
                        return string;
                    }
                    int port = this.getProcess().start(this.timeout, this.testNumber);
                    this.baseURL = this.computeBaseURL(port);
                }
                finally {
                    this.endWriteState();
                    this.beginReadState();
                }
            }
            String string = this.baseURL;
            return string;
        }
        finally {
            this.endReadState();
        }
    }

    private INodejsProcess getProcess() throws TernException {
        if (this.process == null) {
            ITernProject project = super.getProject();
            this.process = NodejsProcessManager.getInstance().create(project.getProjectDir());
            this.process.addProcessListener(this.listener);
        }
        this.initProcess(this.process);
        return this.process;
    }

    private void initProcess(INodejsProcess process) {
        process.setPersistent(this.persistent);
        process.setLoadingLocalPlugins(this.isLoadingLocalPlugins());
    }

    public void addProcessListener(INodejsProcessListener listener) {
        this.beginWriteState();
        try {
            if (this.listeners == null) {
                this.listeners = new ArrayList<INodejsProcessListener>();
            }
            this.listeners.add(listener);
            if (this.process != null) {
                this.process.addProcessListener(listener);
            }
        }
        finally {
            this.endWriteState();
        }
    }

    public void removeProcessListener(INodejsProcessListener listener) {
        this.beginWriteState();
        try {
            if (this.listeners != null && listener != null) {
                this.listeners.remove(listener);
            }
            if (this.process != null) {
                this.process.removeProcessListener(listener);
            }
        }
        finally {
            this.endWriteState();
        }
    }

    public IJSONObjectHelper getJSONObjectHelper() {
        return MinimalJSONHelper.INSTANCE;
    }

    public void doDispose() {
        this.beginWriteState();
        try {
            if (this.process != null) {
                this.process.kill();
            }
            this.baseURL = null;
            this.process = null;
        }
        finally {
            this.endWriteState();
        }
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTestNumber(int testNumber) {
        this.testNumber = testNumber;
    }

    public int getTestNumber() {
        return this.testNumber;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isPersistent() {
        return this.persistent;
    }
}

