/*
 * Decompiled with CFR 0.152.
 */
package tern.server.nodejs.process;

import java.io.File;
import java.util.ArrayList;
import tern.OS;

public class NPMProcessHelper {
    private static final String[] WINDOWS_NODE_PATHS = new String[]{"C:/Program Files/nodejs/npm.cmd".replace('/', File.separatorChar), "C:/Program Files (x86)/nodejs/npm.cmd".replace('/', File.separatorChar), "npm.cmd"};
    private static final String[] MACOS_NODE_PATHS = new String[]{"/usr/local/bin/npm", "/opt/local/bin/npm", "npm"};
    private static final String[] LINUX_NODE_PATHS = new String[]{"/usr/local/bin/npm", "npm"};

    public static String getNPMPath(OS os) {
        String path = NPMProcessHelper.getDefaultNPMPath(os);
        if (path != null) {
            return path;
        }
        File nodeFile = NPMProcessHelper.findNPM(os);
        if (nodeFile != null) {
            return nodeFile.getAbsolutePath();
        }
        return "npm";
    }

    public static String getDefaultNPMPath(OS os) {
        String[] paths = NPMProcessHelper.getDefaultNPMPaths(os);
        String path = null;
        int i = 0;
        while (i < paths.length) {
            path = paths[i];
            if (new File(path).exists()) {
                return path;
            }
            ++i;
        }
        return null;
    }

    public static String[] getDefaultNPMPaths(OS os) {
        switch (os) {
            case Windows: {
                return WINDOWS_NODE_PATHS;
            }
            case MacOS: {
                return MACOS_NODE_PATHS;
            }
        }
        return LINUX_NODE_PATHS;
    }

    public static File findNPM(OS os) {
        String nodeFileName = NPMProcessHelper.getNodeFileName(os);
        String path = System.getenv("PATH");
        String[] paths = path.split("" + File.pathSeparatorChar, 0);
        ArrayList<String> directories = new ArrayList<String>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            directories.add(p);
            ++n2;
        }
        if (os == OS.MacOS) {
            directories.add("/usr/local/bin");
        }
        for (String directory : directories) {
            File nodeFile = new File(directory, nodeFileName);
            if (!nodeFile.exists()) continue;
            return nodeFile;
        }
        return null;
    }

    private static String getNodeFileName(OS os) {
        if (os == OS.Windows) {
            return "npm.cmd";
        }
        return "npm";
    }
}

