/*
 * Decompiled with CFR 0.152.
 */
package tern.server.nodejs.process.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import tern.TernException;
import tern.server.nodejs.process.AbstractNodejsProcess;
import tern.server.nodejs.process.NodejsProcessException;

public class NodejsProcess
extends AbstractNodejsProcess {
    private final File nodejsTernFile;
    private Process process;
    private Thread outThread;
    private Thread errThread;

    public NodejsProcess(File nodejsTernBaseDir, File projectDir) throws TernException {
        this(null, nodejsTernBaseDir, projectDir);
    }

    public NodejsProcess(File nodejsBaseDir, File nodejsTernBaseDir, File projectDir) throws TernException {
        super(nodejsBaseDir, projectDir);
        this.nodejsTernFile = this.getNodejsTernFile(nodejsTernBaseDir);
    }

    private File getNodejsTernFile(File nodejsTernBaseDir) throws TernException {
        if (nodejsTernBaseDir == null) {
            throw new TernException("You must initialize the base dir of the tern node.js server.");
        }
        File ternServerFile = new File(nodejsTernBaseDir, "bin/tern");
        if (!ternServerFile.exists()) {
            try {
                throw new TernException("Cannot find tern node.js server at " + ternServerFile.getCanonicalPath());
            }
            catch (IOException iOException) {
                throw new TernException("Cannot find tern node.js server at " + ternServerFile.getPath());
            }
        }
        return ternServerFile;
    }

    private List<String> createCommands() {
        LinkedList<String> commands = new LinkedList<String>();
        if (this.nodejsBaseDir == null) {
            if (new File("/usr/local/bin/node").exists()) {
                commands.add("/usr/local/bin/node");
            }
            if (new File("/opt/local/bin/node").exists()) {
                commands.add("/opt/local/bin/node");
            } else {
                commands.add("node");
            }
        } else {
            commands.add(this.nodejsBaseDir.getPath());
        }
        try {
            commands.add(this.nodejsTernFile.getCanonicalPath());
        }
        catch (IOException iOException) {
            commands.add(this.nodejsTernFile.getPath());
        }
        commands.addAll(this.createTernServerArgs());
        return commands;
    }

    @Override
    public void start() throws NodejsProcessException {
        if (this.isStarted()) {
            this.notifyErrorProcess("Nodejs tern Server is already started.");
            throw new NodejsProcessException("Nodejs tern Server is already started.");
        }
        try {
            List<String> commands = this.createCommands();
            ProcessBuilder builder = new ProcessBuilder(commands);
            builder.directory(this.getProjectDir());
            this.notifyCreateProcess(commands, this.projectDir);
            this.process = builder.start();
            this.outThread = new Thread(new StdOut());
            this.outThread.setDaemon(true);
            this.outThread.start();
            this.errThread = new Thread(new StdErr());
            this.errThread.setDaemon(true);
            this.errThread.start();
        }
        catch (Throwable e) {
            this.notifyErrorProcess(e.getMessage());
            this.notifyErrorProcess("");
            throw new NodejsProcessException(e);
        }
    }

    @Override
    public boolean isStarted() {
        return this.process != null;
    }

    @Override
    public void kill() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        if (this.outThread != null) {
            this.outThread.interrupt();
            this.outThread = null;
        }
        if (this.errThread != null) {
            this.errThread.interrupt();
            this.errThread = null;
        }
    }

    @Override
    public void join() throws InterruptedException {
        if (this.outThread != null) {
            this.outThread.join();
        }
    }

    private class StdErr
    implements Runnable {
        private StdErr() {
        }

        @Override
        public void run() {
            String line = null;
            InputStream is = NodejsProcess.this.process.getErrorStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            try {
                while ((line = br.readLine()) != null) {
                    NodejsProcess.this.notifyErrorProcess(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class StdOut
    implements Runnable {
        private StdOut() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.nanoTime();
                Integer port = null;
                String line = null;
                InputStream is = NodejsProcess.this.process.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                try {
                    while ((line = br.readLine()) != null) {
                        if (port == null) {
                            if (!line.startsWith("Listening on port ")) continue;
                            port = Integer.parseInt(line.substring("Listening on port ".length(), line.length()));
                            NodejsProcess.this.setPort(port);
                            Object object = NodejsProcess.this.lock;
                            synchronized (object) {
                                NodejsProcess.this.lock.notifyAll();
                            }
                            NodejsProcess.this.notifyStartProcess(startTime);
                            continue;
                        }
                        NodejsProcess.this.notifyDataProcess(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (NodejsProcess.this.process != null) {
                    NodejsProcess.this.process.waitFor();
                }
                NodejsProcess.this.notifyStopProcess();
                NodejsProcess.this.kill();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

