/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.ColumnMapping;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationship;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmBaseEmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmEmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmEmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmMultiRelationshipMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmOneToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmOneToOneMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmSingleRelationshipMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmTransientMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmVersionMapping;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.SimpleMetamodelField;
import org.eclipse.jpt.jpa.core.jpa2.context.AttributeMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelField2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SpecifiedPersistentAttribute2_0;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmAttributeMapping<X extends XmlAttributeMapping>
extends AbstractOrmXmlContextModel<OrmSpecifiedPersistentAttribute>
implements OrmAttributeMapping,
AttributeMapping2_0 {
    protected final X xmlAttributeMapping;
    protected String name;
    protected String specifiedAttributeType;
    protected String defaultAttributeType;
    protected String fullyQualifiedAttributeType;

    protected AbstractOrmAttributeMapping(OrmSpecifiedPersistentAttribute parent, X xmlAttributeMapping) {
        super(parent);
        this.xmlAttributeMapping = xmlAttributeMapping;
        this.name = xmlAttributeMapping.getName();
        this.specifiedAttributeType = this.buildSpecifiedAttributeType();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.xmlAttributeMapping.getName());
        this.setSpecifiedAttributeType_(this.buildSpecifiedAttributeType());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultAttributeType(this.buildDefaultAttributeType());
        this.setFullyQualifiedAttributeType(this.buildFullyQualifiedAttributeType());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName_(name);
        this.xmlAttributeMapping.setName(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        if (this.firePropertyChanged("name", old, name)) {
            this.getPersistentAttribute().nameChanged(old, name);
        }
    }

    @Override
    public String getFullyQualifiedAttributeType() {
        return this.fullyQualifiedAttributeType;
    }

    protected void setFullyQualifiedAttributeType(String attributeType) {
        String old = this.fullyQualifiedAttributeType;
        this.fullyQualifiedAttributeType = attributeType;
        this.firePropertyChanged("fullyQualifiedAttributeType", old, attributeType);
    }

    protected String buildFullyQualifiedAttributeType() {
        return this.specifiedAttributeType == null ? this.defaultAttributeType : this.getEntityMappings().qualify(this.specifiedAttributeType);
    }

    @Override
    public String getAttributeType() {
        return this.specifiedAttributeType != null ? this.specifiedAttributeType : this.defaultAttributeType;
    }

    @Override
    public String getSpecifiedAttributeType() {
        return this.specifiedAttributeType;
    }

    @Override
    public void setSpecifiedAttributeType(String attributeType) {
        this.setSpecifiedAttributeType_(attributeType);
        this.setSpecifiedAttributeTypeInXml(attributeType);
    }

    protected void setSpecifiedAttributeType_(String attributeType) {
        String old = this.specifiedAttributeType;
        this.specifiedAttributeType = attributeType;
        this.firePropertyChanged("specifiedAttributeType", old, attributeType);
    }

    protected void setSpecifiedAttributeTypeInXml(String attributeType) {
    }

    protected String buildSpecifiedAttributeType() {
        return null;
    }

    @Override
    public String getDefaultAttributeType() {
        return this.defaultAttributeType;
    }

    protected void setDefaultAttributeType(String attributeType) {
        String old = this.defaultAttributeType;
        this.defaultAttributeType = attributeType;
        this.firePropertyChanged("defaultAttributeType", old, attributeType);
    }

    protected String buildDefaultAttributeType() {
        return this.getJavaPersistentAttribute() == null ? null : this.getJavaPersistentAttribute().getTypeName(this.getTypeMapping().getPersistentType());
    }

    protected PersistentType getResolvedAttributeType() {
        return this.fullyQualifiedAttributeType == null ? null : this.getPersistenceUnit().getPersistentType(this.fullyQualifiedAttributeType);
    }

    @Override
    public void initializeFromOrmAttributeMapping(OrmAttributeMapping oldMapping) {
        this.setSpecifiedAttributeType(oldMapping.getSpecifiedAttributeType());
    }

    protected void initializeFromOrmColumnMapping(OrmColumnMapping oldMapping) {
        this.initializeFromOrmAttributeMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmBasicMapping(OrmBasicMapping oldMapping) {
        this.initializeFromOrmColumnMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmIdMapping(OrmIdMapping oldMapping) {
        this.initializeFromOrmColumnMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmTransientMapping(OrmTransientMapping oldMapping) {
        this.initializeFromOrmAttributeMapping(oldMapping);
    }

    protected void initializeFromOrmBaseEmbeddedMapping(OrmBaseEmbeddedMapping oldMapping) {
        this.initializeFromOrmAttributeMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmEmbeddedMapping(OrmEmbeddedMapping oldMapping) {
        this.initializeFromOrmBaseEmbeddedMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmEmbeddedIdMapping(OrmEmbeddedIdMapping oldMapping) {
        this.initializeFromOrmBaseEmbeddedMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmVersionMapping(OrmVersionMapping oldMapping) {
        this.initializeFromOrmColumnMapping(oldMapping);
    }

    protected void initializeFromOrmRelationshipMapping(OrmRelationshipMapping oldMapping) {
        this.initializeFromOrmAttributeMapping(oldMapping);
    }

    protected void initializeFromOrmMultiRelationshipMapping(OrmMultiRelationshipMapping oldMapping) {
        this.initializeFromOrmRelationshipMapping(oldMapping);
    }

    protected void initializeFromOrmSingleRelationshipMapping(OrmSingleRelationshipMapping oldMapping) {
        this.initializeFromOrmRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmOneToManyMapping(OrmOneToManyMapping oldMapping) {
        this.initializeFromOrmMultiRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmManyToOneMapping(OrmManyToOneMapping oldMapping) {
        this.initializeFromOrmSingleRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmOneToOneMapping(OrmOneToOneMapping oldMapping) {
        this.initializeFromOrmSingleRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmManyToManyMapping(OrmManyToManyMapping oldMapping) {
        this.initializeFromOrmMultiRelationshipMapping(oldMapping);
    }

    public X getXmlAttributeMapping() {
        return this.xmlAttributeMapping;
    }

    @Override
    public OrmSpecifiedPersistentAttribute getPersistentAttribute() {
        return (OrmSpecifiedPersistentAttribute)this.parent;
    }

    @Override
    public OrmTypeMapping getTypeMapping() {
        return this.getPersistentAttribute().getDeclaringTypeMapping();
    }

    protected JavaSpecifiedPersistentAttribute getJavaPersistentAttribute() {
        return this.getPersistentAttribute().getJavaPersistentAttribute();
    }

    protected EntityMappings getEntityMappings() {
        return this.getPersistentAttribute().getDeclaringPersistentType().getParent();
    }

    protected PersistentType resolvePersistentType(String className) {
        return this.getEntityMappings().resolvePersistentType(className);
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return null;
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return false;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return false;
    }

    @Override
    public boolean isRelationshipOwner() {
        return false;
    }

    @Override
    public boolean isOwnedBy(AttributeMapping mapping) {
        return false;
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getTypeMapping().validatesAgainstDatabase();
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlAttributeMapping.getSelectionTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.xmlAttributeMapping.getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getValidationTextRange(this.xmlAttributeMapping.getNameTextRange());
    }

    @Override
    public Iterable<Generator> getGenerators() {
        return EmptyIterable.instance();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public Iterable<String> getAllMappingNames() {
        return this.name != null ? new SingleElementIterable((Object)this.name) : EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getAllOverridableAttributeMappingNames() {
        return this.name != null && this.isOverridableAttributeMapping() ? new SingleElementIterable((Object)this.name) : EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getAllOverridableAssociationMappingNames() {
        return this.name != null && this.isOverridableAssociationMapping() ? new SingleElementIterable((Object)this.name) : EmptyIterable.instance();
    }

    @Override
    public SpecifiedColumn resolveOverriddenColumn(String attributeName) {
        ColumnMapping mapping = this.resolveColumnMapping(attributeName);
        return mapping == null ? null : mapping.getColumn();
    }

    protected ColumnMapping resolveColumnMapping(String attributeName) {
        AttributeMapping mapping = this.resolveAttributeMapping(attributeName);
        return mapping != null && mapping.isOverridableAttributeMapping() ? (ColumnMapping)mapping : null;
    }

    @Override
    public SpecifiedRelationship resolveOverriddenRelationship(String attributeName) {
        RelationshipMapping mapping = this.resolveRelationshipMapping(attributeName);
        return mapping == null ? null : mapping.getRelationship();
    }

    protected RelationshipMapping resolveRelationshipMapping(String attributeName) {
        AttributeMapping mapping = this.resolveAttributeMapping(attributeName);
        return mapping != null && mapping.isOverridableAssociationMapping() ? (RelationshipMapping)mapping : null;
    }

    @Override
    public AttributeMapping resolveAttributeMapping(String attributeName) {
        return ObjectTools.equals((Object)attributeName, (Object)this.name) ? this : null;
    }

    protected Transformer<String, String> buildQualifierTransformer() {
        return new MappingTools.QualifierTransformer(this.name);
    }

    protected String unqualify(String attributeName) {
        return MappingTools.unqualify(this.name, attributeName);
    }

    @Override
    public MetamodelField2_0 getMetamodelField() {
        String metamodelFieldName = this.getMetamodelFieldName();
        return metamodelFieldName == null ? null : new SimpleMetamodelField(this.getMetamodelFieldModifiers(), this.getMetamodelFieldTypeName(), this.getMetamodelFieldTypeArgumentNames(), metamodelFieldName);
    }

    protected Iterable<String> getMetamodelFieldModifiers() {
        return STANDARD_METAMODEL_FIELD_MODIFIERS;
    }

    protected String getMetamodelFieldTypeName() {
        return "javax.persistence.metamodel.SingularAttribute";
    }

    protected final Iterable<String> getMetamodelFieldTypeArgumentNames() {
        ArrayList<String> typeArgumentNames = new ArrayList<String>(3);
        typeArgumentNames.add(this.getTypeMapping().getPersistentType().getName());
        this.addMetamodelFieldTypeArgumentNamesTo(typeArgumentNames);
        return typeArgumentNames;
    }

    protected void addMetamodelFieldTypeArgumentNamesTo(ArrayList<String> typeArgumentNames) {
        typeArgumentNames.add(this.getMetamodelTypeName());
    }

    @Override
    public String getMetamodelTypeName() {
        return ((SpecifiedPersistentAttribute2_0)((Object)this.getPersistentAttribute())).getMetamodelTypeName();
    }

    protected String getMetamodelFieldName() {
        return this.name;
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateAttribute(messages);
        this.validateMapping(messages);
    }

    protected void validateAttribute(List<IMessage> messages) {
        if (this.name != null && StringTools.isBlank((String)this.name)) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.PERSISTENT_ATTRIBUTE_UNSPECIFIED_NAME));
        }
    }

    protected void validateMapping(List<IMessage> messages) {
        if (!this.getTypeMapping().attributeMappingKeyAllowed(this.getKey())) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.PERSISTENT_ATTRIBUTE_INVALID_MAPPING, this.name));
        }
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.attributeNameTouches(pos)) {
            return this.getCandidateMappingNames();
        }
        return null;
    }

    private Iterable<String> getCandidateMappingNames() {
        JavaPersistentType jpt = this.getTypeMapping().getPersistentType().getJavaPersistentType();
        return jpt == null ? EmptyIterable.instance() : jpt.getAttributeNames();
    }

    private boolean attributeNameTouches(int pos) {
        return this.getXmlAttributeMapping().nameTouches(pos);
    }
}

