/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.GenerationType;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratedValue;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.resource.java.GeneratedValueAnnotation;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaGeneratedValue
extends AbstractJavaContextModel<JavaAttributeMapping>
implements JavaGeneratedValue {
    protected final GeneratedValueAnnotation generatedValueAnnotation;
    protected GenerationType specifiedStrategy;
    protected GenerationType defaultStrategy;
    protected String specifiedGenerator;
    protected String defaultGenerator;

    public GenericJavaGeneratedValue(JavaAttributeMapping parent, GeneratedValueAnnotation generatedValueAnnotation) {
        super(parent);
        this.generatedValueAnnotation = generatedValueAnnotation;
        this.specifiedStrategy = this.buildSpecifiedStrategy();
        this.specifiedGenerator = generatedValueAnnotation.getGenerator();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedStrategy_(this.buildSpecifiedStrategy());
        this.setSpecifiedGenerator_(this.generatedValueAnnotation.getGenerator());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultStrategy(this.buildDefaultStrategy());
        this.setDefaultGenerator(this.buildDefaultGenerator());
    }

    @Override
    public GenerationType getStrategy() {
        return this.specifiedStrategy != null ? this.specifiedStrategy : this.defaultStrategy;
    }

    @Override
    public GenerationType getSpecifiedStrategy() {
        return this.specifiedStrategy;
    }

    @Override
    public void setSpecifiedStrategy(GenerationType strategy) {
        this.generatedValueAnnotation.setStrategy(GenerationType.toJavaResourceModel(strategy));
        this.setSpecifiedStrategy_(strategy);
    }

    protected void setSpecifiedStrategy_(GenerationType strategy) {
        GenerationType old = this.specifiedStrategy;
        this.specifiedStrategy = strategy;
        this.firePropertyChanged("specifiedStrategy", (Object)old, (Object)strategy);
    }

    protected GenerationType buildSpecifiedStrategy() {
        return GenerationType.fromJavaResourceModel(this.generatedValueAnnotation.getStrategy());
    }

    @Override
    public GenerationType getDefaultStrategy() {
        return this.defaultStrategy;
    }

    protected void setDefaultStrategy(GenerationType strategy) {
        GenerationType old = this.defaultStrategy;
        this.defaultStrategy = strategy;
        this.firePropertyChanged("defaultStrategy", (Object)old, (Object)strategy);
    }

    protected GenerationType buildDefaultStrategy() {
        return DEFAULT_STRATEGY;
    }

    @Override
    public String getGenerator() {
        return this.specifiedGenerator != null ? this.specifiedGenerator : this.defaultGenerator;
    }

    @Override
    public String getSpecifiedGenerator() {
        return this.specifiedGenerator;
    }

    @Override
    public void setSpecifiedGenerator(String generator) {
        this.generatedValueAnnotation.setGenerator(generator);
        this.setSpecifiedGenerator_(generator);
    }

    protected void setSpecifiedGenerator_(String generator) {
        String old = this.specifiedGenerator;
        this.specifiedGenerator = generator;
        this.firePropertyChanged("specifiedGenerator", old, generator);
    }

    @Override
    public String getDefaultGenerator() {
        return this.defaultGenerator;
    }

    protected void setDefaultGenerator(String generator) {
        String old = this.defaultGenerator;
        this.defaultGenerator = generator;
        this.firePropertyChanged("defaultGenerator", old, generator);
    }

    protected String buildDefaultGenerator() {
        return null;
    }

    protected JavaAttributeMapping getAttributeMapping() {
        return (JavaAttributeMapping)this.parent;
    }

    @Override
    public GeneratedValueAnnotation getGeneratedValueAnnotation() {
        return this.generatedValueAnnotation;
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.generatorTouches(pos)) {
            return this.getJavaCandidateGeneratorNames();
        }
        return null;
    }

    protected boolean generatorTouches(int pos) {
        return this.generatedValueAnnotation.generatorTouches(pos);
    }

    protected Iterable<String> getJavaCandidateGeneratorNames() {
        return new TransformationIterable(this.getCandidateGeneratorNames(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    protected Iterable<String> getCandidateGeneratorNames() {
        return this.getPersistenceUnit().getUniqueGeneratorNames();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        String generator = this.getGenerator();
        if (generator == null) {
            return;
        }
        for (Generator next : this.getPersistenceUnit().getGenerators()) {
            if (!generator.equals(next.getName())) continue;
            return;
        }
        if (this.getAttributeMapping().getPersistentAttribute().isVirtual()) {
            messages.add(this.buildValidationMessage((JpaModel)this.getAttributeMapping(), this.getAttributeMapping().getPersistentAttribute().getValidationTextRange(), JptJpaCoreValidationMessages.UNRESOLVED_GENERATOR_NAME, generator));
        } else {
            messages.add(this.buildValidationMessage((JpaModel)this.getAttributeMapping(), this.getGeneratorTextRange(), JptJpaCoreValidationMessages.UNRESOLVED_GENERATOR_NAME, generator));
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getAnnotationTextRange();
        return textRange != null ? textRange : this.getAttributeMapping().getValidationTextRange();
    }

    protected TextRange getAnnotationTextRange() {
        return this.generatedValueAnnotation.getTextRange();
    }

    @Override
    public TextRange getGeneratorTextRange() {
        return this.getValidationTextRange(this.generatedValueAnnotation.getGeneratorTextRange());
    }
}

