/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.editor;

import com.liferay.ide.core.model.IModelChangedEvent;
import com.liferay.ide.core.model.IModelChangedListener;
import com.liferay.ide.portlet.core.PluginPackageModel;
import com.liferay.ide.portlet.ui.editor.PluginPackageFormPage;
import com.liferay.ide.ui.form.FormEntry;
import com.liferay.ide.ui.form.FormEntryAdapter;
import com.liferay.ide.ui.form.FormLayoutFactory;
import com.liferay.ide.ui.form.IContextPart;
import com.liferay.ide.ui.form.IDEFormPage;
import com.liferay.ide.ui.form.IDESection;
import com.liferay.ide.ui.form.IFormEntryListener;
import com.liferay.ide.ui.util.SWTUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PluginPackageGeneralSection
extends IDESection
implements IContextPart,
IModelChangedListener {
    protected FormEntry authorEntry;
    protected FormEntry changeLogEntry;
    protected FormEntry licensesEntry;
    protected FormEntry liferayVersionsEntry;
    protected FormEntry longDescriptionEntry;
    protected FormEntry moduleGroupIdEntry;
    protected FormEntry moduleIncrementalVersionEntry;
    protected FormEntry nameEntry;
    protected PluginPackageFormPage page;
    protected FormEntry pageUrlEntry;
    protected FormEntry shortDescriptionEntry;
    protected boolean speedFilterEnabledModifying = false;
    protected Button speedFilters;
    protected FormEntry tagsEntry;

    public PluginPackageGeneralSection(PluginPackageFormPage page, Composite parent) {
        super((IDEFormPage)page, parent, 384);
        this.page = page;
        this.initialize(page.getManagedForm());
        this.getSection().clientVerticalSpacing = 6;
        this.getSection().setData("part", (Object)this);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    public void dispose() {
        super.dispose();
        if (this.getModel() != null) {
            this.getModel().dispose();
        }
    }

    public String getContextId() {
        return "plugin-package-general";
    }

    public IDEFormPage getPage() {
        return this.page;
    }

    public boolean isEditable() {
        return true;
    }

    public void commit(boolean onSave) {
        if (this.validate().isOK()) {
            this.page.form.setMessage("", 0);
            this.refresh();
            super.commit(onSave);
        } else {
            this.page.form.setMessage(this.validate().getMessage(), 3);
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event != null) {
            if (event.getChangeType() == 99) {
                this.refresh();
            } else {
                String changedProperty = event.getChangedProperty();
                Object newValue = event.getNewValue();
                if (changedProperty != null && newValue != null) {
                    if ("name".equals(changedProperty)) {
                        this.nameEntry.setValue(newValue.toString());
                    } else if ("module-group-id".equals(changedProperty)) {
                        this.moduleGroupIdEntry.setValue(newValue.toString());
                    } else if ("module-incremental-version".equals(changedProperty)) {
                        this.moduleIncrementalVersionEntry.setValue(newValue.toString());
                    } else if ("tags".equals(changedProperty)) {
                        this.tagsEntry.setValue(newValue.toString());
                    } else if ("change-log".equals(changedProperty)) {
                        this.changeLogEntry.setValue(newValue.toString());
                    } else if ("page-url".equals(changedProperty)) {
                        this.pageUrlEntry.setValue(newValue.toString());
                    } else if ("author".equals(changedProperty)) {
                        this.authorEntry.setValue(newValue.toString());
                    } else if ("licenses".equals(changedProperty)) {
                        this.licensesEntry.setValue(newValue.toString());
                    } else if ("liferay-versions".equals(changedProperty)) {
                        this.liferayVersionsEntry.setValue(newValue.toString());
                    } else if ("short-description".equals(changedProperty)) {
                        this.shortDescriptionEntry.setValue(newValue.toString());
                    } else if ("long-description".equals(changedProperty)) {
                        this.longDescriptionEntry.setValue(newValue.toString());
                    } else if ("speed-filters-enabled".equals(changedProperty)) {
                        this.speedFilterEnabledModifying = true;
                        this.speedFilters.setSelection(Boolean.parseBoolean(newValue.toString()));
                        this.speedFilterEnabledModifying = false;
                    }
                }
            }
        }
    }

    public void refresh() {
        Boolean speedFiltersEnabled;
        if (this.getModel().getName() != null) {
            this.nameEntry.setValue(this.getModel().getName(), true);
        }
        if (this.getModel().getModuleGroupId() != null) {
            this.moduleGroupIdEntry.setValue(this.getModel().getModuleGroupId(), true);
        }
        if (this.getModel().getModuleIncrementalVersion() != null) {
            this.moduleIncrementalVersionEntry.setValue(this.getModel().getModuleIncrementalVersion(), true);
        }
        if (this.getModel().getTags() != null) {
            this.tagsEntry.setValue(this.getModel().getTags(), true);
        }
        if (this.getModel().getChangeLog() != null) {
            this.changeLogEntry.setValue(this.getModel().getChangeLog(), true);
        }
        if (this.getModel().getAuthor() != null) {
            this.authorEntry.setValue(this.getModel().getAuthor(), true);
        }
        if (this.getModel().getLicenses() != null) {
            this.licensesEntry.setValue(this.getModel().getLicenses(), true);
        }
        if (this.getModel().getPageUrl() != null) {
            this.pageUrlEntry.setValue(this.getModel().getPageUrl(), true);
        }
        if (this.getModel().getLiferayVersions() != null) {
            this.liferayVersionsEntry.setValue(this.getModel().getLiferayVersions(), true);
        }
        if (this.getModel().getShortDescription() != null) {
            this.shortDescriptionEntry.setValue(this.getModel().getShortDescription(), true);
        }
        if (this.getModel().getLongDescription() != null) {
            this.longDescriptionEntry.setValue(this.getModel().getLongDescription(), true);
        }
        this.speedFilters.setSelection((speedFiltersEnabled = this.getModel().isSpeedFiltersEnabled()) != null ? speedFiltersEnabled : false);
        super.refresh();
    }

    private void configureEntry(FormEntry entry) {
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        gd.widthHint = 50;
        entry.getText().setLayoutData((Object)gd);
        entry.setEditable(this.isEditable());
    }

    protected void createAuthorEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.authorEntry = new FormEntry(client, toolkit, Msgs.authorLabel, null, 4, false);
        this.authorEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                PluginPackageGeneralSection.this.getModel().setAuthor(entry.getValue().trim());
            }
        });
        this.configureEntry(this.authorEntry);
    }

    protected void createChangeLogEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.changeLogEntry = new FormEntry(client, toolkit, Msgs.changeLogLabel, null, 4, false);
        this.changeLogEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                PluginPackageGeneralSection.this.getModel().setChangeLog(entry.getValue().trim());
            }
        });
        this.configureEntry(this.changeLogEntry);
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        GridData gd = new GridData(1808);
        gd.minimumWidth = 250;
        gd.grabExcessVerticalSpace = true;
        section.setText(Msgs.general);
        section.setDescription(Msgs.specifyPluginPackageProperties);
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout((boolean)false, (int)1));
        section.setLayoutData((Object)gd);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)3));
        IActionBars actionBars = this.page.getEditor().getEditorSite().getActionBars();
        this.createNameEntry(client, toolkit, actionBars);
        this.createModuleGroupIdEntry(client, toolkit, actionBars);
        this.createModuleIncrementalVersionEntry(client, toolkit, actionBars);
        this.createTagsEntry(client, toolkit, actionBars);
        this.createChangeLogEntry(client, toolkit, actionBars);
        this.createPageUrlEntry(client, toolkit, actionBars);
        this.createAuthorEntry(client, toolkit, actionBars);
        this.createLicensesEntry(client, toolkit, actionBars);
        this.createLiferayVersionsEntry(client, toolkit, actionBars);
        this.createShortDescriptionEntry(client, toolkit, actionBars);
        this.createLongDescriptionEntry(client, toolkit, actionBars);
        this.createSpeedFiltersEntry(client, toolkit, actionBars);
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    protected void createLicensesEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.licensesEntry = new FormEntry(client, toolkit, Msgs.licensesLabel, null, 4, false);
        this.licensesEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                PluginPackageGeneralSection.this.getModel().setLicenses(entry.getValue().trim());
            }
        });
        this.configureEntry(this.licensesEntry);
    }

    protected void createLiferayVersionsEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.liferayVersionsEntry = new FormEntry(client, toolkit, Msgs.liferayVersionsLabel, null, 4, false);
        this.liferayVersionsEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                PluginPackageGeneralSection.this.getModel().setLiferayVersions(entry.getValue().trim());
            }
        });
        this.configureEntry(this.liferayVersionsEntry);
    }

    protected void createModuleGroupIdEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.moduleGroupIdEntry = new FormEntry(client, toolkit, Msgs.moduleGroupIdLabel, null, 4, false);
        this.moduleGroupIdEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                PluginPackageGeneralSection.this.getModel().setModuleGroupId(entry.getValue().trim());
            }
        });
        this.configureEntry(this.moduleGroupIdEntry);
    }

    protected void createModuleIncrementalVersionEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.moduleIncrementalVersionEntry = new FormEntry(client, toolkit, Msgs.moduleVersionLabel, null, 4, false);
        this.moduleIncrementalVersionEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                PluginPackageGeneralSection.this.getModel().setModuleIncrementalVersion(entry.getValue().trim());
            }
        });
        this.configureEntry(this.moduleIncrementalVersionEntry);
    }

    protected void createNameEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.nameEntry = new FormEntry(client, toolkit, Msgs.nameLabel, null, 4, false);
        this.nameEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                PluginPackageGeneralSection.this.getModel().setName(entry.getValue().trim());
            }
        });
        this.configureEntry(this.nameEntry);
    }

    protected void createPageUrlEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.pageUrlEntry = new FormEntry(client, toolkit, Msgs.pageURLLabel, null, 4, false);
        this.pageUrlEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                PluginPackageGeneralSection.this.getModel().setPageUrl(entry.getValue().trim());
            }
        });
        this.configureEntry(this.pageUrlEntry);
    }

    protected void createShortDescriptionEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 5;
        gd.heightHint = 20;
        gd.widthHint = 100;
        this.shortDescriptionEntry = new FormEntry(client, toolkit, Msgs.shortDescriptionLabel, null, 4, false);
        this.shortDescriptionEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                PluginPackageGeneralSection.this.getModel().setShortDescription(entry.getValue().trim());
            }
        });
        this.shortDescriptionEntry.getText().setLayoutData((Object)gd);
        this.shortDescriptionEntry.setEditable(this.isEditable());
    }

    protected void createLongDescriptionEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 5;
        gd.heightHint = 75;
        gd.widthHint = 100;
        int style = 578;
        this.longDescriptionEntry = new FormEntry(client, toolkit, Msgs.longDescriptionLabel, null, style, false);
        this.longDescriptionEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                PluginPackageGeneralSection.this.getModel().setLongDescription(entry.getValue().trim());
            }
        });
        this.longDescriptionEntry.getText().setLayoutData((Object)gd);
        this.longDescriptionEntry.setEditable(this.isEditable());
    }

    protected void createSpeedFiltersEntry(Composite parent, FormToolkit toolkit, IActionBars actionBars) {
        SWTUtil.createLabel((Composite)parent, (String)"", (int)1);
        GridData td = new GridData();
        td.horizontalSpan = 5;
        this.speedFilters = toolkit.createButton(parent, Msgs.speedFilters, 32);
        this.speedFilters.setLayoutData((Object)td);
        this.speedFilters.setEnabled(this.isEditable());
        this.speedFilters.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!PluginPackageGeneralSection.this.speedFilterEnabledModifying) {
                    PluginPackageGeneralSection.this.getModel().setSpeedFiltersEnabled(PluginPackageGeneralSection.this.speedFilters.getSelection());
                }
            }
        });
    }

    protected void createTagsEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.tagsEntry = new FormEntry(client, toolkit, Msgs.tagsLabel, null, 4, false);
        this.tagsEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                PluginPackageGeneralSection.this.getModel().setTags(entry.getValue().trim());
            }
        });
        this.configureEntry(this.tagsEntry);
    }

    protected PluginPackageModel getModel() {
        return (PluginPackageModel)this.getPage().getLiferayFormEditor().getModel();
    }

    protected IStatus validate() {
        if ("" == this.getModel().getModuleGroupId()) {
            return new Status(4, "com.liferay.ide.portlet.ui", "Module Group Id can't be empty");
        }
        if (this.getModel().getModuleGroupId().startsWith("/")) {
            return new Status(4, "com.liferay.ide.portlet.ui", "Module Group Id can't start with '/'");
        }
        return new Status(0, "com.liferay.ide.portlet.ui", "");
    }

    private static class Msgs
    extends NLS {
        public static String authorLabel;
        public static String changeLogLabel;
        public static String general;
        public static String licensesLabel;
        public static String liferayVersionsLabel;
        public static String longDescriptionLabel;
        public static String moduleGroupIdLabel;
        public static String moduleVersionLabel;
        public static String nameLabel;
        public static String pageURLLabel;
        public static String shortDescriptionLabel;
        public static String specifyPluginPackageProperties;
        public static String speedFilters;
        public static String tagsLabel;

        static {
            Msgs.initializeMessages((String)PluginPackageGeneralSection.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

