/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.editor.internal;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.portlet.core.util.PortletUtil;
import com.liferay.ide.portlet.ui.PortletUIPlugin;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.PropertyEditorActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;

public abstract class AbstractResourceBundleActionHandler
extends PropertyEditorActionHandler {
    final IWorkspace workspace = ResourcesPlugin.getWorkspace();
    final IWorkspaceRoot wroot = this.workspace.getRoot();
    protected Listener listener;

    protected boolean computeEnablementState() {
        boolean isEnabled = super.computeEnablementState();
        if (isEnabled) {
            String ioFileName;
            Element element = this.getModelElement();
            Property property = this.property();
            IProject project = (IProject)element.adapt(IProject.class);
            String rbFile = element.property((ValueProperty)property.definition()).text();
            isEnabled = rbFile != null ? !this.getFileFromClasspath(project, ioFileName = PortletUtil.convertJavaToIoFileName((String)rbFile, (String)"properties", (String[])new String[0])) : false;
        }
        return isEnabled;
    }

    protected final boolean getFileFromClasspath(IProject project, String ioFileName) {
        IClasspathEntry[] cpEntries;
        IClasspathEntry[] iClasspathEntryArray = cpEntries = CoreUtil.getClasspathEntries((IProject)project);
        int n = cpEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
            if (3 == iClasspathEntry.getEntryKind()) {
                IPath entryPath = this.wroot.getFolder(iClasspathEntry.getPath()).getLocation();
                IFile resourceBundleFile = this.wroot.getFileForLocation(entryPath = entryPath.append(ioFileName));
                return resourceBundleFile != null && resourceBundleFile.exists();
            }
            ++n2;
        }
        return false;
    }

    protected final IFolder getResourceBundleFolderLocation(IProject project, String ioFileName) {
        IClasspathEntry[] cpEntries;
        IClasspathEntry[] iClasspathEntryArray = cpEntries = CoreUtil.getClasspathEntries((IProject)project);
        int n = cpEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
            if (3 == iClasspathEntry.getEntryKind()) {
                IFolder srcFolder = this.wroot.getFolder(iClasspathEntry.getPath());
                IPath rbSourcePath = srcFolder.getLocation();
                IFile resourceBundleFile = this.wroot.getFileForLocation(rbSourcePath = rbSourcePath.append(ioFileName));
                if (resourceBundleFile != null) {
                    return srcFolder;
                }
            }
            ++n2;
        }
        return null;
    }

    protected final void createFiles(Presentation context, final IProject project, final String packageName, final List<IFile> rbFiles, final StringBuilder rbFileBuffer) {
        if (!rbFiles.isEmpty()) {
            final int workUnit = rbFiles.size() + 2;
            IRunnableWithProgress rbCreationProc = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", workUnit);
                    try {
                        try {
                            IJavaProject javaProject = JavaCore.create((IProject)project);
                            IPackageFragmentRoot pkgSrc = PortletUtil.getSourceFolder((IJavaProject)javaProject);
                            IPackageFragment rbPackageFragment = pkgSrc.getPackageFragment(packageName);
                            if (rbPackageFragment != null && !rbPackageFragment.exists()) {
                                pkgSrc.createPackageFragment(packageName, true, monitor);
                            }
                            monitor.worked(1);
                            ListIterator rbFilesIterator = rbFiles.listIterator();
                            while (rbFilesIterator.hasNext()) {
                                IFile rbFile = (IFile)rbFilesIterator.next();
                                rbFile.create((InputStream)new ByteArrayInputStream(rbFileBuffer.toString().getBytes()), true, monitor);
                                monitor.worked(1);
                            }
                            project.refreshLocal(2, monitor);
                        }
                        catch (CoreException e) {
                            PortletUIPlugin.logError((Exception)((Object)e));
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                new ProgressMonitorDialog(((SwtPresentation)context).shell()).run(false, false, rbCreationProc);
                rbFiles.clear();
            }
            catch (InvocationTargetException e) {
                PortletUIPlugin.logError(e);
            }
            catch (InterruptedException e) {
                PortletUIPlugin.logError(e);
            }
        }
    }
}

