/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.coordinates.jre;

import com.google.common.base.Optional;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.recommenders.coordinates.AbstractProjectCoordinateAdvisor;
import org.eclipse.recommenders.coordinates.Coordinates;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.DependencyType;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Versions;

public class JREReleaseFileAdvisor
extends AbstractProjectCoordinateAdvisor {
    @Override
    protected Optional<ProjectCoordinate> doSuggest(DependencyInfo dependencyInfo) {
        Optional<FileInputStream> optionalReleaseFileInputStream = this.readReleaseFileIn(dependencyInfo.getFile());
        if (!optionalReleaseFileInputStream.isPresent()) {
            return Optional.absent();
        }
        InputStream releaseFileInputStream = (InputStream)optionalReleaseFileInputStream.get();
        try {
            Optional<ProjectCoordinate> optional = this.extractProjectCoordinateOfReleaseFile(releaseFileInputStream);
            return optional;
        }
        catch (IOException iOException) {
            Optional optional = Optional.absent();
            return optional;
        }
        finally {
            IOUtils.closeQuietly((Closeable)releaseFileInputStream);
        }
    }

    private Optional<ProjectCoordinate> extractProjectCoordinateOfReleaseFile(InputStream releaseFileInputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(releaseFileInputStream);
        String version = properties.getProperty("JAVA_VERSION");
        if (version == null) {
            return Optional.absent();
        }
        version = version.replace("\"", "");
        return Coordinates.tryNewProjectCoordinate("jre", "jre", Versions.canonicalizeVersion((String)version));
    }

    private Optional<FileInputStream> readReleaseFileIn(File folderPath) {
        try {
            File file = new File(String.valueOf(folderPath.getAbsolutePath()) + File.separator + "release");
            return Optional.fromNullable((Object)new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return Optional.absent();
        }
    }

    @Override
    public boolean isApplicable(DependencyType dependencyType) {
        return dependencyType == DependencyType.JRE;
    }
}

