/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.action;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.ui.LiferayServerUI;
import com.liferay.ide.server.ui.navigator.PropertiesFile;
import com.liferay.ide.server.ui.util.ServerUIUtil;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;

public class OpenLiferayHomeFolderAction
extends SelectionProviderAction {
    private Shell shell;

    public OpenLiferayHomeFolderAction(ISelectionProvider sp) {
        super(sp, "Open Liferay Home Folder");
    }

    public OpenLiferayHomeFolderAction(ISelectionProvider selectionProvider, String text) {
        this(null, selectionProvider, text);
    }

    public OpenLiferayHomeFolderAction(Shell shell, ISelectionProvider selectionProvider, String text) {
        super(selectionProvider, text);
        this.shell = shell;
        this.setEnabled(false);
    }

    public boolean accept(Object node) {
        return node instanceof PropertiesFile;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void perform(Object entry) {
        if (entry instanceof PropertiesFile) {
            PropertiesFile workflowEntry = (PropertiesFile)entry;
            String path = workflowEntry.getPath();
            try {
                ServerUIUtil.openFileInSystemExplorer((IPath)new Path(path));
            }
            catch (IOException e) {
                LiferayServerUI.logError("Error opening portal home folder.", e);
            }
        }
    }

    public void run() {
        Iterator iterator = this.getStructuredSelection().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        Object obj = iterator.next();
        if (this.accept(obj)) {
            this.perform(obj);
        }
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        boolean enabled = false;
        for (Object obj : sel) {
            if (obj instanceof PropertiesFile) {
                PropertiesFile node = (PropertiesFile)obj;
                String path = node.getPath();
                try {
                    if (CoreUtil.isNullOrEmpty((String)ServerUIUtil.getSystemExplorerCommand(new Path(path).toFile())) || !this.accept(node)) continue;
                    enabled = true;
                }
                catch (IOException iOException) {}
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(enabled);
    }
}

