/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.contentassist;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistProposalRecorder;
import org.eclipse.wst.xml.search.editor.internal.contentassist.CompilationUnitHelper;
import org.eclipse.wst.xml.search.editor.internal.contentassist.JavaCompletionProposalCollector;
import org.eclipse.wst.xml.search.editor.internal.jdt.SuperTypeHierarchyCache;
import org.eclipse.wst.xml.search.editor.internal.util.EditorUtils;
import org.eclipse.wst.xml.search.editor.util.JdtUtils;

public class JavaCompletionUtils {
    private static final CompletionProposalComparator COMPARATOR = new CompletionProposalComparator();
    private static ILabelProvider JAVA_LABEL_PROVIDER = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT | 0x800);
    public static final int FLAG_INTERFACE = 4;
    public static final int FLAG_CLASS = 8;
    public static final int FLAG_PACKAGE = 16;

    public static void addClassValueProposals(String prefix, IFile file, IContentAssistProposalRecorder recorder) {
        if (prefix == null || prefix.length() == 0) {
            return;
        }
        try {
            ICompletionProposal[] proposals;
            ICompilationUnit unit = JavaCompletionUtils.createSourceCompilationUnit(file, prefix);
            char enclosingChar = prefix.lastIndexOf(36) <= 0 ? (char)'.' : '$';
            prefix = prefix.replace('$', '.');
            if (prefix.lastIndexOf(46) > 0) {
                String rootClass = prefix.substring(0, prefix.lastIndexOf(46));
                IType type = JdtUtils.getJavaType(file.getProject(), rootClass);
                if (type != null) {
                    IType[] aitype = type.getTypes();
                    int j = aitype.length;
                    int i = 0;
                    while (i < j) {
                        IType innerType = aitype[i];
                        if (Flags.isPrivate((int)innerType.getFlags()) && innerType.getFullyQualifiedName('.').startsWith(prefix)) {
                            recorder.recordProposal(JAVA_LABEL_PROVIDER.getImage((Object)innerType), 10, JAVA_LABEL_PROVIDER.getText((Object)innerType), innerType.getFullyQualifiedName(enclosingChar), innerType);
                        }
                        ++i;
                    }
                }
            }
            String sourceStart = "public class _xxx {\n    public void main(String[] args) {\n        " + prefix;
            String packageName = null;
            int dot = prefix.lastIndexOf(46);
            if (dot > -1) {
                packageName = prefix.substring(0, dot);
                sourceStart = "package " + packageName + ";\n" + sourceStart;
            }
            String source = String.valueOf(sourceStart) + "\n    }\n}";
            JavaCompletionUtils.setContents(unit, source);
            JavaCompletionProposalCollector collector = new JavaCompletionProposalCollector(unit);
            unit.codeComplete(sourceStart.length(), (CompletionRequestor)collector, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
            IJavaCompletionProposal[] props = collector.getJavaCompletionProposals();
            ICompletionProposal[] aicompletionproposal = proposals = JavaCompletionUtils.order((ICompletionProposal[])props);
            int l = proposals.length;
            int k = 0;
            while (k < l) {
                ICompletionProposal comProposal = aicompletionproposal[k];
                JavaCompletionUtils.processJavaCompletionProposal(recorder, comProposal, packageName, enclosingChar);
                ++k;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private static ICompilationUnit createSourceCompilationUnit(IFile file, String prefix) throws JavaModelException {
        IProgressMonitor progressMonitor = EditorUtils.getProgressMonitor();
        IJavaProject project = JavaCore.create((IProject)file.getProject());
        IPackageFragment root = JavaCompletionUtils.getPackageFragment(project, prefix);
        ICompilationUnit unit = root.getCompilationUnit("_xxx.java").getWorkingCopy(CompilationUnitHelper.getInstance().getWorkingCopyOwner(), (IProblemRequestor)CompilationUnitHelper.getInstance().getProblemRequestor(), progressMonitor);
        progressMonitor.done();
        return unit;
    }

    private static IPackageFragment getPackageFragment(IJavaProject project, String prefix) throws JavaModelException {
        int dot = prefix.lastIndexOf(46);
        if (dot > -1) {
            IPackageFragment[] packages;
            String packageName = prefix.substring(0, dot);
            IPackageFragmentRoot[] aipackagefragmentroot1 = project.getPackageFragmentRoots();
            int l = aipackagefragmentroot1.length;
            int j = 0;
            while (j < l) {
                IPackageFragmentRoot root = aipackagefragmentroot1[j];
                IPackageFragment p = root.getPackageFragment(packageName);
                if (p != null && p.exists()) {
                    return p;
                }
                ++j;
            }
            IPackageFragment[] aipackagefragment = packages = project.getPackageFragments();
            int j1 = packages.length;
            int i1 = 0;
            while (i1 < j1) {
                IPackageFragment p = aipackagefragment[i1];
                if (p.getElementName().equals(packageName)) {
                    return p;
                }
                ++i1;
            }
        } else {
            IPackageFragmentRoot[] aipackagefragmentroot = project.getAllPackageFragmentRoots();
            int k = aipackagefragmentroot.length;
            int i = 0;
            while (i < k) {
                IPackageFragmentRoot p = aipackagefragmentroot[i];
                if (p.getKind() == 1) {
                    return p.getPackageFragment("");
                }
                ++i;
            }
        }
        return project.getPackageFragments()[0];
    }

    private static ICompletionProposal[] order(ICompletionProposal[] proposals) {
        Arrays.sort(proposals, COMPARATOR);
        return proposals;
    }

    private static void processJavaCompletionProposal(IContentAssistProposalRecorder recorder, ICompletionProposal comProposal, String packageName, char enclosingChar) {
        if (comProposal instanceof JavaCompletionProposal) {
            JavaCompletionProposal prop = (JavaCompletionProposal)comProposal;
            JavaCompletionUtils.recordProposal(recorder, prop.getImage(), prop.getRelevance(), prop.getDisplayString(), prop.getReplacementString(), prop.getJavaElement());
        } else if (comProposal instanceof LazyJavaTypeCompletionProposal) {
            LazyJavaTypeCompletionProposal prop = (LazyJavaTypeCompletionProposal)comProposal;
            if (prop.getQualifiedTypeName().equals(String.valueOf(packageName) + "." + "_xxx") || prop.getQualifiedTypeName().equals("_xxx")) {
                return;
            }
            if (prop.getJavaElement() instanceof IType) {
                if (TypeFilter.isFiltered((IType)((IType)prop.getJavaElement()))) {
                    return;
                }
                String replacementString = ((IType)prop.getJavaElement()).getFullyQualifiedName(enclosingChar);
                JavaCompletionUtils.recordProposal(recorder, prop.getImage(), prop.getRelevance(), prop.getDisplayString(), replacementString, prop.getJavaElement());
            }
        }
    }

    private static void recordProposal(IContentAssistProposalRecorder recorder, Image image, int relevance, String displayText, String replaceText, Object proposedObject) {
        String s = null;
        if (proposedObject instanceof IMember) {
            s = new ProposalInfo((IMember)proposedObject).getInfo(EditorUtils.getProgressMonitor());
        }
        recorder.recordProposal(image, relevance, displayText, replaceText, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setContents(ICompilationUnit cu, String source) {
        if (cu == null) {
            return;
        }
        ICompilationUnit iCompilationUnit = cu;
        synchronized (iCompilationUnit) {
            IBuffer buffer;
            try {
                buffer = cu.getBuffer();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                buffer = null;
            }
            if (buffer != null) {
                buffer.setContents(source);
            }
        }
    }

    public static void addTypeHierachyAttributeValueProposals(String prefix, IFile file, IContentAssistProposalRecorder recorder, IType type, int flags) {
        try {
            if (type != null && file.getProject().hasNature("org.eclipse.jdt.core.javanature") && !TypeFilter.isFiltered((IType)type)) {
                ITypeHierarchy hierachy = SuperTypeHierarchyCache.getTypeHierarchy(type, EditorUtils.getProgressMonitor());
                IType[] types = hierachy.getAllSubtypes(type);
                HashMap<String, IType> sortMap = new HashMap<String, IType>();
                IType[] aitype = types;
                int j = types.length;
                int i = 0;
                while (i < j) {
                    IType foundType = aitype[i];
                    if ((foundType.getFullyQualifiedName().startsWith(prefix) || foundType.getElementName().startsWith(prefix)) && !sortMap.containsKey(foundType.getFullyQualifiedName()) && !Flags.isAbstract((int)foundType.getFlags())) {
                        boolean accepted = false;
                        if ((flags & 8) != 0 && !Flags.isInterface((int)foundType.getFlags())) {
                            accepted = true;
                        } else if ((flags & 4) != 0 && Flags.isInterface((int)foundType.getFlags())) {
                            accepted = true;
                        }
                        if (accepted) {
                            String displayText = null;
                            displayText = foundType.getPackageFragment().getElementName().equals("") ? String.valueOf(foundType.getElementName()) : String.valueOf(foundType.getElementName()) + " - " + foundType.getPackageFragment().getElementName();
                            int refevance = 1000;
                            JavaCompletionUtils.recordProposal(recorder, JavaPluginImages.get((String)"org.eclipse.jdt.ui.class_obj.gif"), refevance, displayText, foundType.getFullyQualifiedName(), foundType);
                            sortMap.put(foundType.getFullyQualifiedName(), foundType);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException coreException) {}
    }
}

