/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.contentassist;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistCalculator;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistContext;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistProposalRecorder;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToExpression;
import org.eclipse.wst.xml.search.editor.searchers.IXMLSearcher;

public class XMLReferencesContentAssistCalculator
implements IContentAssistCalculator {
    private IXMLReference reference;
    private IDOMNode selectedNode;

    public XMLReferencesContentAssistCalculator(IXMLReference reference, IDOMNode selectedNode) {
        this.reference = reference;
        this.selectedNode = selectedNode;
    }

    @Override
    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        IFile file = context.getFile();
        if (this.reference.isExpression()) {
            IXMLReferenceToExpression expression = (IXMLReferenceToExpression)this.reference;
            IXMLSearcher searcher = expression.getSearcher();
            if (searcher != null) {
                searcher.searchForCompletion(this.selectedNode, context.getMatchString(), null, null, file, expression, recorder);
            }
        } else {
            List<IXMLReferenceTo> toPath = this.reference.getTo();
            for (IXMLReferenceTo referenceTo : toPath) {
                IXMLSearcher searcher = referenceTo.getSearcher();
                if (searcher == null) continue;
                searcher.searchForCompletion(this.selectedNode, context.getMatchString(), null, null, file, referenceTo, recorder);
            }
        }
    }
}

