/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.hyperlink;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.editor.internal.util.EditorUtils;

public class DOMNodeHyperlink
implements IHyperlink,
IRegion {
    private int offset;
    private int length;
    private final IRegion region;
    private final IDOMNode node;

    public DOMNodeHyperlink(IRegion region, IDOMNode node, int startOffset, int endOffset) {
        this.region = region;
        this.node = node;
        this.offset = region.getOffset();
        if (startOffset != -1) {
            this.offset += startOffset;
        }
        this.length = region.getLength();
        if (endOffset != -1) {
            this.length = endOffset - startOffset;
        }
    }

    public IRegion getHyperlinkRegion() {
        return this;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return "Open '" + this.node.getLocalName() + "' - " + this.node.getModel().getBaseLocation();
    }

    public void open() {
        EditorUtils.openInEditor(this.node);
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }
}

