/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.searchers.expressions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToExpression;
import org.eclipse.wst.xml.search.editor.searchers.expressions.AbstractExpressionParser;
import org.eclipse.wst.xml.search.editor.searchers.expressions.ResultToken;
import org.eclipse.wst.xml.search.editor.searchers.expressions.SearcherToken;

public class BaseTokenExpressionParser
extends AbstractExpressionParser {
    private final char token;

    public BaseTokenExpressionParser(char token) {
        this.token = token;
    }

    @Override
    public SearcherToken parse(String nodeValue, String matchingString, IXMLReferenceToExpression toExpression) {
        ResultToken resultToken = new ResultToken(this.token, nodeValue, matchingString);
        String realMatchingString = resultToken.getRealMatchingString();
        List<String> tokens = resultToken.getTokens();
        String tokenId = this.getTokenId(tokens, this.getTokenIndex(tokens));
        String beforeText = this.getBeforeText(nodeValue, matchingString, realMatchingString, tokenId, tokens);
        String endText = this.getEndText(nodeValue, resultToken.getEndToken(), matchingString, tokenId, tokens);
        return this.createSearcherToken(toExpression, tokenId, realMatchingString, beforeText, endText);
    }

    protected String getTokenId(List<String> tokens, int tokenIndex) {
        return "___ALL_TOKEN";
    }

    protected String getEndText(String nodeValue, String endToken, String matchingString, String tokenId, List<String> tokens) {
        char firstChar;
        String endText = nodeValue.substring(matchingString.length() + endToken.length(), nodeValue.length());
        if (endText.length() > 0 && (firstChar = endText.charAt(0)) != this.token && this.addTokenAtFirst(tokenId, tokens)) {
            return String.valueOf(this.token) + endText;
        }
        return endText;
    }

    protected boolean addTokenAtFirst(String tokenId, List<String> tokens) {
        return true;
    }

    protected int getTokenIndex(List<String> tokens) {
        return tokens.size() > 0 ? tokens.size() - 1 : 0;
    }

    protected String getBeforeText(String nodeValue, String matchingString, String realMatchingString, String tokenId, List<String> tokens) {
        return matchingString.substring(0, matchingString.length() - realMatchingString.length());
    }

    @Override
    public SearcherToken[] parse(String nodeValue, IXMLReferenceToExpression toExpression) {
        ResultToken resultToken = new ResultToken(this.token, nodeValue);
        List<String> tokens = resultToken.getTokens();
        String tokenId = null;
        ArrayList<SearcherToken> searcherTokens = new ArrayList<SearcherToken>();
        int startOffsetOfStartToken = 0;
        String lastToken = null;
        int i = 0;
        for (String token : tokens) {
            if (lastToken != null) {
                ++startOffsetOfStartToken;
                startOffsetOfStartToken += lastToken.length();
            }
            lastToken = token;
            tokenId = this.getTokenId(tokens, i++);
            searcherTokens.add(this.createSearcherToken(toExpression, tokenId, token, startOffsetOfStartToken));
        }
        return searcherTokens.toArray(SearcherToken.EMPTY);
    }

    @Override
    public SearcherToken parse(String nodeValue, int offset, IXMLReferenceToExpression toExpression) {
        ResultToken resultToken = new ResultToken(this.token, nodeValue, offset);
        String realMatchingString = resultToken.getRealMatchingString();
        List<String> tokens = resultToken.getTokens();
        String tokenId = this.getTokenId(tokens, this.getTokenIndex(tokens));
        return this.createSearcherToken(toExpression, tokenId, realMatchingString, resultToken.getStartOffsetOfStartToken());
    }
}

