/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.searchers.javamethod.requestor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.requestor.AbstractJavaMethodRequestor;

public class BeansJavaMethodRequestor
extends AbstractJavaMethodRequestor {
    protected static final String SET_PREFIX = "set";
    protected static final String GET_PREFIX = "get";
    protected static final String IS_PREFIX = "is";
    private final String prefix;
    private final int prefixLength;
    private final boolean checkCaseForFirstChar;

    public BeansJavaMethodRequestor(String prefix, boolean checkCaseForFirstChar) {
        this.prefix = prefix;
        this.prefixLength = prefix.length();
        this.checkCaseForFirstChar = checkCaseForFirstChar;
    }

    @Override
    protected String formatMethodName(Object selectedNode, IMethod method) {
        if (!this.isStartPefix(method)) {
            return null;
        }
        if (method.getElementName().length() <= this.prefixLength) {
            return null;
        }
        String formattedMethodName = method.getElementName().substring(this.prefixLength, method.getElementName().length());
        Boolean b = this.isUpperCaseForFirstChar();
        if (b == null) {
            return formattedMethodName;
        }
        String fisrtChar = formattedMethodName.substring(0, 1);
        if (b.booleanValue()) {
            return String.valueOf(fisrtChar.toUpperCase()) + formattedMethodName.substring(1, formattedMethodName.length());
        }
        return String.valueOf(fisrtChar.toLowerCase()) + formattedMethodName.substring(1, formattedMethodName.length());
    }

    @Override
    protected IStatus validate(IMethod method) {
        IStatus status = super.validate(method);
        if (status == null || status.isOK()) {
            if (!this.isStartPefix(method)) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
        return status;
    }

    protected boolean isStartPefix(IMethod method) {
        String methodName = method.getElementName();
        return methodName.startsWith(this.prefix);
    }

    @Override
    protected boolean isMatchPartial(String matching, String methodNameTest) {
        if (matching.length() == 0) {
            return true;
        }
        if (super.isMatchPartial(matching.substring(1, matching.length()), methodNameTest.substring(1, methodNameTest.length()))) {
            String s1 = matching.substring(0, 1);
            String s2 = methodNameTest.substring(0, 1);
            return s1.equalsIgnoreCase(s2);
        }
        return false;
    }

    @Override
    protected boolean isMatchTotally(String methodNameFromXML, String methodNameTest) {
        if (methodNameFromXML.length() < this.prefixLength) {
            return false;
        }
        if (super.isMatchTotally(methodNameFromXML.substring(1, methodNameFromXML.length()), methodNameTest.substring(1, methodNameTest.length()))) {
            String s1 = methodNameFromXML.substring(0, 1);
            String s2 = methodNameTest.substring(0, 1);
            return s1.equalsIgnoreCase(s2);
        }
        return false;
    }

    protected Boolean isUpperCaseForFirstChar() {
        return false;
    }
}

