/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.chain.rcp;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import java.lang.reflect.Field;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.codeassist.InternalExtendedCompletionContext;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.recommenders.completion.rcp.CompletionContextKey;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.utils.Reflections;

@Beta
public final class ScopeAccessWorkaround {
    private static final Field EXTENDED_CONTEXT = (Field)Reflections.getDeclaredField(InternalCompletionContext.class, (String)"extendedContext").orNull();
    private static final Field ASSIST_SCOPE = (Field)Reflections.getDeclaredField(InternalExtendedCompletionContext.class, (String)"assistScope").orNull();

    private ScopeAccessWorkaround() {
    }

    public static Optional<Scope> resolveScope(IRecommendersCompletionContext ctx) {
        InternalCompletionContext context = (InternalCompletionContext)ctx.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
        if (context == null) {
            return Optional.absent();
        }
        if (EXTENDED_CONTEXT == null || ASSIST_SCOPE == null) {
            return Optional.absent();
        }
        try {
            InternalExtendedCompletionContext extendedContext = (InternalExtendedCompletionContext)EXTENDED_CONTEXT.get(context);
            if (extendedContext == null) {
                return Optional.absent();
            }
            return Optional.fromNullable((Object)((Scope)ASSIST_SCOPE.get(extendedContext)));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

