/*
 * Decompiled with CFR 0.152.
 */
package tern.angular.protocol;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonValue;
import tern.angular.AngularType;
import tern.angular.protocol.TernAngularScope;
import tern.server.protocol.JsonHelper;
import tern.server.protocol.TernQuery;

public class TernAngularQuery
extends TernQuery {
    private final JsonArray angularTypes;

    public TernAngularQuery(String subtype, AngularType angularType) {
        super("angular");
        super.add("subtype", subtype);
        this.angularTypes = new JsonArray();
        super.add("angularTypes", (JsonValue)this.angularTypes);
        this.addType(angularType);
    }

    public void addType(AngularType angularType) {
        this.angularTypes.add(angularType.name());
    }

    public void setExpression(String expression) {
        super.add("expression", expression);
    }

    public TernAngularScope getScope() {
        TernAngularScope scope = (TernAngularScope)super.get("scope");
        if (scope == null) {
            scope = new TernAngularScope();
            super.add("scope", (JsonValue)scope);
        }
        return scope;
    }

    public boolean hasScope() {
        TernAngularScope scope = (TernAngularScope)super.get("scope");
        return scope != null;
    }

    public boolean hasControllers() {
        if (!this.hasScope()) {
            return false;
        }
        TernAngularScope scope = (TernAngularScope)super.get("scope");
        return scope.hasControllers();
    }

    public boolean hasModule() {
        if (!this.hasScope()) {
            return false;
        }
        TernAngularScope scope = (TernAngularScope)super.get("scope");
        return scope.hasModule();
    }

    public void addFile(String file) {
        this.getFiles().add(file);
    }

    public JsonArray getFiles() {
        JsonArray files = (JsonArray)super.get("files");
        if (files == null) {
            files = new JsonArray();
            super.add("files", (JsonValue)files);
        }
        return files;
    }

    public boolean hasFiles() {
        JsonArray files = (JsonArray)super.get("files");
        if (files == null) {
            return false;
        }
        return files.size() > 0;
    }

    public AngularType getFirstAngularType() {
        return AngularType.get(((JsonArray)super.get("angularTypes")).get(0).asString());
    }

    @Override
    public String getLabel() {
        return super.getLabel() + "_" + this.getSubType();
    }

    private String getSubType() {
        return JsonHelper.getString(this, "subtype");
    }
}

